
package org.mule.modules.salesforce.config;

import org.mule.modules.salesforce.processors.GetDeletedMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class GetDeletedDefinitionParser
    extends AbstractDefinitionParser
{


    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GetDeletedMessageProcessor.class.getName());
        parseConfigRef(element, builder);
        parseProperty(builder, element, "type");
        parseProperty(builder, element, "duration");
        parseProperty(builder, element, "retryMax");
        parseProperty(builder, element, "username");
        parseProperty(builder, element, "password");
        parseProperty(builder, element, "securityToken");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
