
package org.mule.modules.salesforce.config;

import org.mule.modules.salesforce.processors.QueryAllMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class QueryAllDefinitionParser
    extends AbstractDefinitionParser
{


    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(QueryAllMessageProcessor.class.getName());
        parseConfigRef(element, builder);
        parseProperty(builder, element, "query");
        parseProperty(builder, element, "retryMax");
        parseProperty(builder, element, "username");
        parseProperty(builder, element, "password");
        parseProperty(builder, element, "securityToken");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
