/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;

@Connector(name="sns", schemaVersion="1.0", friendlyName="Amazon SNS")
public class AmazonSNSConnector {
    private String accessKey;
    private AmazonSNS client;

    @Connect
    public void connect(@ConnectionKey String accessKey, String secretKey) throws ConnectionException {
        this.client = new AmazonSNSClient((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        this.setAccessKey(accessKey);
        try {
            this.listTopics(new ListTopicsRequest());
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage());
        }
    }

    @Disconnect
    public void disconnect() {
        this.client = null;
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.client != null;
    }

    @ConnectionIdentifier
    public String connectionId() {
        return this.getAccessKey();
    }

    @Processor
    public void addPermission(@Optional @Default(value="#[payload]") AddPermissionRequest addPermissionRequest) {
        this.client.addPermission(addPermissionRequest);
    }

    @Processor
    public ConfirmSubscriptionResult confirmSubscription(@Optional @Default(value="#[payload]") ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        return this.client.confirmSubscription(confirmSubscriptionRequest);
    }

    @Processor
    public CreateTopicResult createTopic(@Optional @Default(value="#[payload]") CreateTopicRequest createTopicRequest) {
        return this.client.createTopic(createTopicRequest);
    }

    @Processor
    public void deleteTopic(@Optional @Default(value="#[payload]") DeleteTopicRequest deleteTopicRequest) {
        this.client.deleteTopic(deleteTopicRequest);
    }

    @Processor
    public GetSubscriptionAttributesResult getSubscriptionAttributes(@Optional @Default(value="#[payload]") GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) {
        return this.client.getSubscriptionAttributes(getSubscriptionAttributesRequest);
    }

    @Processor
    public GetTopicAttributesResult getTopicAttributes(@Optional @Default(value="#[payload]") GetTopicAttributesRequest getTopicAttributesRequest) {
        return this.client.getTopicAttributes(getTopicAttributesRequest);
    }

    @Processor
    public ListSubscriptionsResult listSubscriptions(@Optional @Default(value="#[payload]") ListSubscriptionsRequest listSubscriptionsRequest) {
        return this.client.listSubscriptions(listSubscriptionsRequest);
    }

    @Processor
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(@Optional @Default(value="#[payload]") ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) {
        return this.client.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
    }

    @Processor
    public ListTopicsResult listTopics(@Optional @Default(value="#[payload]") ListTopicsRequest listTopicsRequest) {
        return this.client.listTopics(listTopicsRequest);
    }

    @Processor
    public PublishResult publish(@Optional @Default(value="#[payload]") PublishRequest publishRequest) {
        return this.client.publish(publishRequest);
    }

    @Processor
    public void removePermission(@Optional @Default(value="#[payload]") RemovePermissionRequest removePermissionRequest) {
        this.client.removePermission(removePermissionRequest);
    }

    @Processor
    public void setSubscriptionAttributes(@Optional @Default(value="#[payload]") SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        this.client.setSubscriptionAttributes(setSubscriptionAttributesRequest);
    }

    @Processor
    public void setTopicAttributes(@Optional @Default(value="#[payload]") SetTopicAttributesRequest setTopicAttributesRequest) {
        this.client.setTopicAttributes(setTopicAttributesRequest);
    }

    @Processor
    public SubscribeResult subscribe(@Optional @Default(value="#[payload]") SubscribeRequest subscribeRequest) {
        return this.client.subscribe(subscribeRequest);
    }

    @Processor
    public void unsubscribe(@Optional @Default(value="#[payload]") UnsubscribeRequest unsubscribeRequest) {
        this.client.unsubscribe(unsubscribeRequest);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }
}

