/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.sns.adapters.AmazonSNSConnectorConnectionIdentifierAdapter;
import org.mule.modules.sns.connectivity.AmazonSNSConnectorConnectionKey;
import org.mule.modules.sns.connectivity.AmazonSNSConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonSNSConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(AmazonSNSConnectorConnectionFactory.class);
    private AmazonSNSConnectorConnectionManager connectionManager;

    public AmazonSNSConnectorConnectionFactory(AmazonSNSConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof AmazonSNSConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        AmazonSNSConnectorConnectionIdentifierAdapter connector = new AmazonSNSConnectorConnectionIdentifierAdapter();
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof AmazonSNSConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof AmazonSNSConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((AmazonSNSConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((AmazonSNSConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((AmazonSNSConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof AmazonSNSConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((AmazonSNSConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof AmazonSNSConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof AmazonSNSConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((AmazonSNSConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((AmazonSNSConnectorConnectionIdentifierAdapter)obj).connect(((AmazonSNSConnectorConnectionKey)key).getAccessKey(), ((AmazonSNSConnectorConnectionKey)key).getSecretKey());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

