/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.api.ConnectionManager;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.sns.adapters.AmazonSNSConnectorConnectionIdentifierAdapter;
import org.mule.modules.sns.connectivity.AmazonSNSConnectorConnectionFactory;
import org.mule.modules.sns.connectivity.AmazonSNSConnectorConnectionKey;
import org.mule.modules.sns.connectivity.ManagedConnectionProcessTemplate;

public class AmazonSNSConnectorConnectionManager
implements Capabilities,
ConnectionManager<AmazonSNSConnectorConnectionKey, AmazonSNSConnectorConnectionIdentifierAdapter>,
MetadataAware,
MuleContextAware,
Initialisable,
ProcessAdapter<AmazonSNSConnectorConnectionIdentifierAdapter> {
    private String accessKey;
    private String secretKey;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Amazon SNS";
    private static final String MODULE_VERSION = "1.0";
    private static final String DEVKIT_VERSION = "3.3.2";
    private static final String DEVKIT_BUILD = "UNNAMED.1372.db235f3";

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setAccessKey(String value) {
        this.accessKey = value;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setSecretKey(String value) {
        this.secretKey = value;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
            config.timeBetweenEvictionRunsMillis = 1800000L;
            config.minEvictableIdleTimeMillis = 1800000L;
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new AmazonSNSConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public AmazonSNSConnectorConnectionIdentifierAdapter acquireConnection(AmazonSNSConnectorConnectionKey key) throws Exception {
        return (AmazonSNSConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    public void releaseConnection(AmazonSNSConnectorConnectionKey key, AmazonSNSConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    public void destroyConnection(AmazonSNSConnectorConnectionKey key, AmazonSNSConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, AmazonSNSConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    public AmazonSNSConnectorConnectionKey getDefaultConnectionKey() {
        return new AmazonSNSConnectorConnectionKey(this.getAccessKey(), this.getSecretKey());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }
}

