/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns.process;

import org.mule.api.Connection;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.UnableToAcquireConnectionException;
import org.mule.api.UnableToReleaseConnectionException;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.sns.adapters.AmazonSNSConnectorConnectionIdentifierAdapter;
import org.mule.modules.sns.connectivity.AmazonSNSConnectorConnectionKey;
import org.mule.modules.sns.processors.AbstractConnectedProcessor;
import org.mule.modules.sns.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, AmazonSNSConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<AmazonSNSConnectorConnectionKey, AmazonSNSConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, AmazonSNSConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, AmazonSNSConnectorConnectionIdentifierAdapter> next, ConnectionManager<AmazonSNSConnectorConnectionKey, AmazonSNSConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, AmazonSNSConnectorConnectionIdentifierAdapter> processCallback, AmazonSNSConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object _transformedAccessKey;
        AmazonSNSConnectorConnectionIdentifierAdapter connection = null;
        AmazonSNSConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getAccessKey() != null) {
            _transformedAccessKey = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_accessKeyType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getAccessKey());
            String _transformedSecretKey = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_secretKeyType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getSecretKey());
            key = new AmazonSNSConnectorConnectionKey((String)_transformedAccessKey, _transformedSecretKey);
        } else {
            key = (AmazonSNSConnectorConnectionKey)this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = (AmazonSNSConnectorConnectionIdentifierAdapter)this.connectionManager.acquireConnection((Object)key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedAccessKey = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)_transformedAccessKey;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection((Object)key, (Connection)connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection((Object)key, (Connection)connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException((Throwable)e);
            }
        }
    }

    public T execute(ProcessCallback<T, AmazonSNSConnectorConnectionIdentifierAdapter> processCallback, AmazonSNSConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

