/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.http;

import com.amazonaws.1.9.39.shade.ClientConfiguration;
import com.amazonaws.1.9.39.shade.http.IdleConnectionReaper;
import java.util.concurrent.TimeUnit;
import org.apache.http.4.3.5.shade.impl.conn.PoolingClientConnectionManager;
import org.apache.http.4.3.5.shade.impl.conn.SchemeRegistryFactory;
import org.apache.http.4.3.5.shade.params.HttpParams;

class ConnectionManagerFactory {
    ConnectionManagerFactory() {
    }

    public static PoolingClientConnectionManager createPoolingClientConnManager(ClientConfiguration config, HttpParams httpClientParams) {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), config.getConnectionTTL(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        if (config.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(connectionManager);
        }
        return connectionManager;
    }
}

