/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.http;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.AmazonServiceException;
import com.amazonaws.1.9.39.shade.http.HttpResponse;
import com.amazonaws.1.9.39.shade.http.HttpResponseHandler;
import com.amazonaws.1.9.39.shade.transform.Unmarshaller;
import com.amazonaws.1.9.39.shade.util.IOUtils;
import com.amazonaws.1.9.39.shade.util.XpathUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        Document document;
        String content = "";
        try {
            content = IOUtils.toString(errorResponse.getContent());
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed in reading the error response", (Throwable)ex);
            }
            return this.newAmazonServiceException("Unable to unmarshall error response", errorResponse, ex);
        }
        try {
            document = XpathUtils.documentFrom(content);
        }
        catch (Exception e) {
            return this.newAmazonServiceException(String.format("Unable to unmarshall error response (%s)", content), errorResponse, e);
        }
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        throw new AmazonClientException("Unable to unmarshall error response from service");
    }

    private AmazonServiceException newAmazonServiceException(String errmsg, HttpResponse httpResponse, Exception readFailure) {
        AmazonServiceException exception = new AmazonServiceException(errmsg, readFailure);
        int statusCode = httpResponse.getStatusCode();
        exception.setErrorCode(statusCode + " " + httpResponse.getStatusText());
        exception.setErrorType(AmazonServiceException.ErrorType.Unknown);
        exception.setStatusCode(statusCode);
        return exception;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

