/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.http;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.ClientConfiguration;
import com.amazonaws.1.9.39.shade.http.AmazonHttpClient;
import com.amazonaws.1.9.39.shade.http.ConnectionManagerFactory;
import com.amazonaws.1.9.39.shade.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.1.9.39.shade.http.impl.client.HttpRequestNoRetryHandler;
import com.amazonaws.1.9.39.shade.http.impl.client.SdkHttpClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.4.3.5.shade.Header;
import org.apache.http.4.3.5.shade.HeaderElement;
import org.apache.http.4.3.5.shade.HttpEntity;
import org.apache.http.4.3.5.shade.HttpException;
import org.apache.http.4.3.5.shade.HttpHost;
import org.apache.http.4.3.5.shade.HttpRequest;
import org.apache.http.4.3.5.shade.HttpRequestInterceptor;
import org.apache.http.4.3.5.shade.HttpResponse;
import org.apache.http.4.3.5.shade.HttpResponseInterceptor;
import org.apache.http.4.3.5.shade.ProtocolException;
import org.apache.http.4.3.5.shade.auth.AuthScope;
import org.apache.http.4.3.5.shade.auth.ChallengeState;
import org.apache.http.4.3.5.shade.auth.NTCredentials;
import org.apache.http.4.3.5.shade.client.AuthCache;
import org.apache.http.4.3.5.shade.client.HttpClient;
import org.apache.http.4.3.5.shade.client.RedirectStrategy;
import org.apache.http.4.3.5.shade.client.entity.GzipDecompressingEntity;
import org.apache.http.4.3.5.shade.client.methods.HttpUriRequest;
import org.apache.http.4.3.5.shade.conn.ConnectTimeoutException;
import org.apache.http.4.3.5.shade.conn.params.ConnRouteParams;
import org.apache.http.4.3.5.shade.conn.scheme.PlainSocketFactory;
import org.apache.http.4.3.5.shade.conn.scheme.Scheme;
import org.apache.http.4.3.5.shade.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.4.3.5.shade.conn.scheme.SchemeRegistry;
import org.apache.http.4.3.5.shade.conn.scheme.SchemeSocketFactory;
import org.apache.http.4.3.5.shade.conn.ssl.SSLSocketFactory;
import org.apache.http.4.3.5.shade.impl.auth.BasicScheme;
import org.apache.http.4.3.5.shade.impl.client.BasicAuthCache;
import org.apache.http.4.3.5.shade.impl.conn.PoolingClientConnectionManager;
import org.apache.http.4.3.5.shade.params.BasicHttpParams;
import org.apache.http.4.3.5.shade.params.HttpConnectionParams;
import org.apache.http.4.3.5.shade.params.HttpParams;
import org.apache.http.4.3.5.shade.protocol.HttpContext;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpClientParams, config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(httpClientParams, config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled(httpClientParams, true);
        HttpConnectionParams.setTcpNoDelay(httpClientParams, true);
        HttpConnectionParams.setSoKeepalive(httpClientParams, config.useTcpKeepAlive());
        int socketSendBufferSizeHint = config.getSocketBufferSizeHints()[0];
        int socketReceiveBufferSizeHint = config.getSocketBufferSizeHints()[1];
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize(httpClientParams, Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        PoolingClientConnectionManager connectionManager = ConnectionManagerFactory.createPoolingClientConnManager(config, httpClientParams);
        SdkHttpClient httpClient = new SdkHttpClient(connectionManager, httpClientParams);
        httpClient.setHttpRequestRetryHandler(HttpRequestNoRetryHandler.Singleton);
        httpClient.setRedirectStrategy(new NeverFollowRedirectStrategy());
        if (config.getLocalAddress() != null) {
            ConnRouteParams.setLocalAddress(httpClientParams, config.getLocalAddress());
        }
        try {
            Scheme http = new Scheme("http", 80, PlainSocketFactory.getSocketFactory());
            SSLSocketFactory sf = config.getApacheHttpClientConfig().getSslSocketFactory();
            if (sf == null) {
                sf = new SdkTLSSocketFactory(SSLContext.getDefault(), SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            }
            Scheme https = new Scheme("https", 443, sf);
            SchemeRegistry sr = connectionManager.getSchemeRegistry();
            sr.register(http);
            sr.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to access default SSL context", e);
        }
        if (System.getProperty("com.amazonaws.1.9.39.shade.sdk.disableCertChecking") != null) {
            Scheme sch = new Scheme("https", 443, new TrustingSocketFactory());
            httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            AmazonHttpClient.log.info((Object)("Configuring Proxy. Proxy Host: " + proxyHost + " " + "Proxy Port: " + proxyPort));
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
            if (config.isPreemptiveBasicProxyAuth()) {
                httpClient.addRequestInterceptor(new PreemptiveProxyAuth(proxyHttpHost), 0);
            }
        }
        if (config.useGzip()) {
            httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                @Override
                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (!request.containsHeader("Accept-Encoding")) {
                        request.addHeader("Accept-Encoding", "gzip");
                    }
                }
            });
            httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                @Override
                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    Header ceheader;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                        HeaderElement[] codecs = ceheader.getElements();
                        for (int i = 0; i < codecs.length; ++i) {
                            if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                            response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                    }
                }
            });
        }
        return httpClient;
    }

    private static class PreemptiveProxyAuth
    implements HttpRequestInterceptor {
        private final HttpHost proxyHost;

        public PreemptiveProxyAuth(HttpHost proxyHost) {
            this.proxyHost = proxyHost;
        }

        @Override
        public void process(HttpRequest request, HttpContext context) {
            BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
            if (context.getAttribute("http.auth.auth-cache") == null) {
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(this.proxyHost, basicScheme);
                context.setAttribute("http.auth.auth-cache", authCache);
            } else {
                AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
                authCache.put(this.proxyHost, basicScheme);
            }
        }
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements SchemeSocketFactory,
    SchemeLayeredSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return context;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }

        @Override
        public Socket createSocket(HttpParams params) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        @Override
        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            int connTimeout = HttpConnectionParams.getConnectionTimeout(params);
            int soTimeout = HttpConnectionParams.getSoTimeout(params);
            SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket(params));
            if (localAddress != null) {
                sslsock.bind(localAddress);
            }
            sslsock.connect(remoteAddress, connTimeout);
            sslsock.setSoTimeout(soTimeout);
            return sslsock;
        }

        @Override
        public boolean isSecure(Socket sock) throws IllegalArgumentException {
            return true;
        }

        @Override
        public Socket createLayeredSocket(Socket arg0, String arg1, int arg2, HttpParams arg3) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(arg0, arg1, arg2, true);
        }
    }

    private static final class NeverFollowRedirectStrategy
    implements RedirectStrategy {
        private NeverFollowRedirectStrategy() {
        }

        @Override
        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        @Override
        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }
}

