/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.http;

import com.amazonaws.1.9.39.shade.AmazonWebServiceRequest;
import com.amazonaws.1.9.39.shade.http.HttpMethodName;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpMethodName methodName;
    private String serviceName;
    private URI endpoint;
    private String resourcePath;
    private InputStream inputStream;
    private AmazonWebServiceRequest originalRequest;

    public HttpRequest(HttpMethodName methodName) {
        this.methodName = methodName;
    }

    public HttpMethodName getMethodName() {
        return this.methodName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public HttpRequest withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setContent(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getContent() {
        return this.inputStream;
    }

    public void setOriginalRequest(AmazonWebServiceRequest request) {
        this.originalRequest = request;
    }

    public AmazonWebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String toString() {
        String value;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethodName().toString() + " ");
        builder.append(this.getEndpoint().toString() + " ");
        builder.append("/" + (this.getResourcePath() != null ? this.getResourcePath() : "") + " ");
        if (!this.getParameters().isEmpty()) {
            builder.append("Parameters: (");
            for (String key : this.getParameters().keySet()) {
                value = this.getParameters().get(key);
                builder.append(key + ": " + value + ", ");
            }
            builder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append("Headers: (");
            for (String key : this.getHeaders().keySet()) {
                value = this.getHeaders().get(key);
                builder.append(key + ": " + value + ", ");
            }
            builder.append(") ");
        }
        return builder.toString();
    }
}

