/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.retry;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.AmazonWebServiceRequest;
import com.amazonaws.1.9.39.shade.retry.PredefinedRetryPolicies;
import org.apache.http.4.3.5.shade.annotation.Immutable;

@Immutable
public final class RetryPolicy {
    private final RetryCondition retryCondition;
    private final BackoffStrategy backoffStrategy;
    private final int maxErrorRetry;
    private final boolean honorMaxErrorRetryInClientConfig;

    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy, int maxErrorRetry, boolean honorMaxErrorRetryInClientConfig) {
        if (retryCondition == null) {
            retryCondition = PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION;
        }
        if (backoffStrategy == null) {
            backoffStrategy = PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY;
        }
        if (maxErrorRetry < 0) {
            throw new IllegalArgumentException("Please provide a non-negative value for maxErrorRetry.");
        }
        this.retryCondition = retryCondition;
        this.backoffStrategy = backoffStrategy;
        this.maxErrorRetry = maxErrorRetry;
        this.honorMaxErrorRetryInClientConfig = honorMaxErrorRetryInClientConfig;
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public boolean isMaxErrorRetryInClientConfigHonored() {
        return this.honorMaxErrorRetryInClientConfig;
    }

    public static interface BackoffStrategy {
        public static final BackoffStrategy NO_DELAY = new BackoffStrategy(){

            @Override
            public long delayBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
                return 0L;
            }
        };

        public long delayBeforeNextRetry(AmazonWebServiceRequest var1, AmazonClientException var2, int var3);
    }

    public static interface RetryCondition {
        public static final RetryCondition NO_RETRY_CONDITION = new RetryCondition(){

            @Override
            public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
                return false;
            }
        };

        public boolean shouldRetry(AmazonWebServiceRequest var1, AmazonClientException var2, int var3);
    }
}

