/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.sns.util;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.AmazonServiceException;
import com.amazonaws.1.9.39.shade.auth.policy.Policy;
import com.amazonaws.1.9.39.shade.auth.policy.Principal;
import com.amazonaws.1.9.39.shade.auth.policy.Resource;
import com.amazonaws.1.9.39.shade.auth.policy.Statement;
import com.amazonaws.1.9.39.shade.auth.policy.actions.SQSActions;
import com.amazonaws.1.9.39.shade.auth.policy.conditions.ConditionFactory;
import com.amazonaws.1.9.39.shade.services.sns.AmazonSNS;
import com.amazonaws.1.9.39.shade.services.sns.model.SubscribeRequest;
import com.amazonaws.1.9.39.shade.services.sns.model.SubscribeResult;
import com.amazonaws.1.9.39.shade.services.sqs.AmazonSQS;
import com.amazonaws.1.9.39.shade.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.1.9.39.shade.services.sqs.model.QueueAttributeName;
import com.amazonaws.1.9.39.shade.services.sqs.model.SetQueueAttributesRequest;
import java.util.HashMap;
import java.util.Map;

public class Topics {
    public static String subscribeQueue(AmazonSNS sns, AmazonSQS sqs, String snsTopicArn, String sqsQueueUrl) throws AmazonClientException, AmazonServiceException {
        Map<String, String> queueAttributes = sqs.getQueueAttributes(new GetQueueAttributesRequest(sqsQueueUrl).withAttributeNames(QueueAttributeName.QueueArn.toString())).getAttributes();
        String sqsQueueArn = queueAttributes.get(QueueAttributeName.QueueArn.toString());
        Policy policy = new Policy().withStatements(new Statement(Statement.Effect.Allow).withId("topic-subscription-" + snsTopicArn).withPrincipals(Principal.AllUsers).withActions(SQSActions.SendMessage).withResources(new Resource(sqsQueueArn)).withConditions(ConditionFactory.newSourceArnCondition(snsTopicArn)));
        System.out.println("Policy: " + policy.toJson());
        queueAttributes = new HashMap<String, String>();
        queueAttributes.put(QueueAttributeName.Policy.toString(), policy.toJson());
        sqs.setQueueAttributes(new SetQueueAttributesRequest(sqsQueueUrl, queueAttributes));
        SubscribeResult subscribeResult = sns.subscribe(new SubscribeRequest().withEndpoint(sqsQueueArn).withProtocol("sqs").withTopicArn(snsTopicArn));
        return subscribeResult.getSubscriptionArn();
    }
}

