/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.sqs.internal;

import com.amazonaws.1.9.39.shade.Request;
import com.amazonaws.1.9.39.shade.handlers.AbstractRequestHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class SQSRequestHandler
extends AbstractRequestHandler {
    private static final Map<String, String> nonstandardEndpointMap = new HashMap<String, String>();

    @Override
    public void beforeRequest(Request<?> request) {
        URI endpoint = request.getEndpoint();
        if (nonstandardEndpointMap.containsKey(endpoint.getHost())) {
            String newHost = nonstandardEndpointMap.get(endpoint.getHost());
            String newEndpoint = endpoint.toString().replaceFirst(endpoint.getHost(), newHost);
            request.setEndpoint(URI.create(newEndpoint));
        }
    }

    static {
        nonstandardEndpointMap.put("queue.amazonaws.com", "sqs.us-east-1.amazonaws.com");
        nonstandardEndpointMap.put("us-west-1.queue.amazonaws.com", "sqs.us-west-1.amazonaws.com");
        nonstandardEndpointMap.put("us-west-2.queue.amazonaws.com", "sqs.us-west-2.amazonaws.com");
        nonstandardEndpointMap.put("eu-west-1.queue.amazonaws.com", "sqs.eu-west-1.amazonaws.com");
        nonstandardEndpointMap.put("ap-southeast-1.queue.amazonaws.com", "sqs.ap-southeast-1.amazonaws.com");
        nonstandardEndpointMap.put("ap-northeast-1.queue.amazonaws.com", "sqs.ap-northeast-1.amazonaws.com");
        nonstandardEndpointMap.put("sa-east-1.queue.amazonaws.com", "sqs.sa-east-1.amazonaws.com");
        nonstandardEndpointMap.put("us-gov-west-1.queue.amazonaws.com", "sqs.us-gov-west-1.amazonaws.com");
        nonstandardEndpointMap.put("ap-southeast-2.queue.amazonaws.com", "sqs.ap-southeast-2.amazonaws.com");
    }
}

