/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.sqs.model.transform;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.DefaultRequest;
import com.amazonaws.1.9.39.shade.Request;
import com.amazonaws.1.9.39.shade.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.1.9.39.shade.transform.Marshaller;
import com.amazonaws.1.9.39.shade.util.StringUtils;
import java.util.List;

public class ReceiveMessageRequestMarshaller
implements Marshaller<Request<ReceiveMessageRequest>, ReceiveMessageRequest> {
    @Override
    public Request<ReceiveMessageRequest> marshall(ReceiveMessageRequest receiveMessageRequest) {
        if (receiveMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReceiveMessageRequest> request = new DefaultRequest<ReceiveMessageRequest>(receiveMessageRequest, "AmazonSQS");
        request.addParameter("Action", "ReceiveMessage");
        request.addParameter("Version", "2012-11-05");
        if (receiveMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(receiveMessageRequest.getQueueUrl()));
        }
        List<String> attributeNamesList = receiveMessageRequest.getAttributeNames();
        int attributeNamesListIndex = 1;
        for (String attributeNamesListValue : attributeNamesList) {
            if (attributeNamesListValue != null) {
                request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString(attributeNamesListValue));
            }
            ++attributeNamesListIndex;
        }
        List<String> messageAttributeNamesList = receiveMessageRequest.getMessageAttributeNames();
        int messageAttributeNamesListIndex = 1;
        for (String messageAttributeNamesListValue : messageAttributeNamesList) {
            if (messageAttributeNamesListValue != null) {
                request.addParameter("MessageAttributeName." + messageAttributeNamesListIndex, StringUtils.fromString(messageAttributeNamesListValue));
            }
            ++messageAttributeNamesListIndex;
        }
        if (receiveMessageRequest.getMaxNumberOfMessages() != null) {
            request.addParameter("MaxNumberOfMessages", StringUtils.fromInteger(receiveMessageRequest.getMaxNumberOfMessages()));
        }
        if (receiveMessageRequest.getVisibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringUtils.fromInteger(receiveMessageRequest.getVisibilityTimeout()));
        }
        if (receiveMessageRequest.getWaitTimeSeconds() != null) {
            request.addParameter("WaitTimeSeconds", StringUtils.fromInteger(receiveMessageRequest.getWaitTimeSeconds()));
        }
        return request;
    }
}

