/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.client.methods;

import java.net.URI;
import org.apache.http.4.3.5.shade.ProtocolVersion;
import org.apache.http.4.3.5.shade.RequestLine;
import org.apache.http.4.3.5.shade.annotation.NotThreadSafe;
import org.apache.http.4.3.5.shade.client.config.RequestConfig;
import org.apache.http.4.3.5.shade.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.4.3.5.shade.client.methods.Configurable;
import org.apache.http.4.3.5.shade.client.methods.HttpUriRequest;
import org.apache.http.4.3.5.shade.message.BasicRequestLine;
import org.apache.http.4.3.5.shade.params.HttpProtocolParams;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    public URI getURI() {
        return this.uri;
    }

    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

