/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.client.protocol;

import java.io.IOException;
import org.apache.http.4.3.5.shade.HttpEntity;
import org.apache.http.4.3.5.shade.HttpEntityEnclosingRequest;
import org.apache.http.4.3.5.shade.HttpException;
import org.apache.http.4.3.5.shade.HttpRequest;
import org.apache.http.4.3.5.shade.HttpRequestInterceptor;
import org.apache.http.4.3.5.shade.HttpVersion;
import org.apache.http.4.3.5.shade.ProtocolVersion;
import org.apache.http.4.3.5.shade.annotation.Immutable;
import org.apache.http.4.3.5.shade.client.config.RequestConfig;
import org.apache.http.4.3.5.shade.client.protocol.HttpClientContext;
import org.apache.http.4.3.5.shade.protocol.HttpContext;
import org.apache.http.4.3.5.shade.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

