/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.impl.io;

import java.io.IOException;
import org.apache.http.4.3.5.shade.ConnectionClosedException;
import org.apache.http.4.3.5.shade.HttpException;
import org.apache.http.4.3.5.shade.HttpRequest;
import org.apache.http.4.3.5.shade.HttpRequestFactory;
import org.apache.http.4.3.5.shade.ParseException;
import org.apache.http.4.3.5.shade.RequestLine;
import org.apache.http.4.3.5.shade.annotation.NotThreadSafe;
import org.apache.http.4.3.5.shade.config.MessageConstraints;
import org.apache.http.4.3.5.shade.impl.DefaultHttpRequestFactory;
import org.apache.http.4.3.5.shade.impl.io.AbstractMessageParser;
import org.apache.http.4.3.5.shade.io.SessionInputBuffer;
import org.apache.http.4.3.5.shade.message.LineParser;
import org.apache.http.4.3.5.shade.message.ParserCursor;
import org.apache.http.4.3.5.shade.params.HttpParams;
import org.apache.http.4.3.5.shade.util.Args;
import org.apache.http.4.3.5.shade.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

