/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns.config;

import org.mule.config.MuleManifest;
import org.mule.modules.sns.config.AddPermissionDefinitionParser;
import org.mule.modules.sns.config.AmazonSNSConnectorConfigConfigDefinitionParser;
import org.mule.modules.sns.config.ConfirmSubscriptionDefinitionParser;
import org.mule.modules.sns.config.CreateTopicDefinitionParser;
import org.mule.modules.sns.config.DeleteTopicDefinitionParser;
import org.mule.modules.sns.config.GetSubscriptionAttributesDefinitionParser;
import org.mule.modules.sns.config.GetTopicAttributesDefinitionParser;
import org.mule.modules.sns.config.ListSubscriptionsByTopicDefinitionParser;
import org.mule.modules.sns.config.ListSubscriptionsDefinitionParser;
import org.mule.modules.sns.config.ListTopicsDefinitionParser;
import org.mule.modules.sns.config.PublishDefinitionParser;
import org.mule.modules.sns.config.RemovePermissionDefinitionParser;
import org.mule.modules.sns.config.SetSubscriptionAttributesDefinitionParser;
import org.mule.modules.sns.config.SetTopicAttributesDefinitionParser;
import org.mule.modules.sns.config.SubscribeDefinitionParser;
import org.mule.modules.sns.config.UnsubscribeDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class SnsNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(SnsNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [sns] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [sns] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new AmazonSNSConnectorConfigConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("add-permission", (BeanDefinitionParser)new AddPermissionDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("add-permission", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("confirm-subscription", (BeanDefinitionParser)new ConfirmSubscriptionDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("confirm-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-topic", (BeanDefinitionParser)new CreateTopicDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("create-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-topic", (BeanDefinitionParser)new DeleteTopicDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("delete-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-subscription-attributes", (BeanDefinitionParser)new GetSubscriptionAttributesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-subscription-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-topic-attributes", (BeanDefinitionParser)new GetTopicAttributesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-topic-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-subscriptions", (BeanDefinitionParser)new ListSubscriptionsDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("list-subscriptions", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-subscriptions-by-topic", (BeanDefinitionParser)new ListSubscriptionsByTopicDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("list-subscriptions-by-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topics", (BeanDefinitionParser)new ListTopicsDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("list-topics", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("publish", (BeanDefinitionParser)new PublishDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("publish", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("remove-permission", (BeanDefinitionParser)new RemovePermissionDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("remove-permission", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("set-subscription-attributes", (BeanDefinitionParser)new SetSubscriptionAttributesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("set-subscription-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("set-topic-attributes", (BeanDefinitionParser)new SetTopicAttributesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("set-topic-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("subscribe", (BeanDefinitionParser)new SubscribeDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("subscribe", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("unsubscribe", (BeanDefinitionParser)new UnsubscribeDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("unsubscribe", "@Processor", ex);
        }
    }
}

