/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.List;

/**
 * A wrapper type for the attributes of an AddPermission operation.
 */
public class AddPermission implements Serializable {

    private static final long serialVersionUID = -7653847603988538632L;
    /**
     * The ARN of the topic whose access control policy you wish to modify.
     */
    @NotNull
    private String topicArn;

    /**
     * A unique identifier for the new policy statement.
     */
    @NotNull
    private String label;

    /**
     * The AWS account IDs of the users (principals) who will be given access to the specified actions. The users must have AWS accounts, but do not need to be signed up for this
     * service.
     */
    @NotNull
    List<String> aWSAccountIds;

    /**
     * The action you want to allow for the specified principal(s)
     */
    @NotNull
    List<String> actionNames;

    public List<String> getActionNames() {
        return actionNames;
    }

    public void setActionNames(List<String> actionNames) {
        this.actionNames = actionNames;
    }

    public List<String> getaWSAccountIds() {
        return aWSAccountIds;
    }

    public void setaWSAccountIds(List<String> aWSAccountIds) {
        this.aWSAccountIds = aWSAccountIds;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}
