/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * A wrapper type for the attributes of RemovePermission operation.
 */
public class RemovePermission implements Serializable {

    private static final long serialVersionUID = -2929792052281941580L;
    /**
     * The ARN of the topic whose access control policy you wish to modify.
     */
    @NotNull
    private String topicArn;

    /**
     * The unique label of the statement you want to remove.
     */
    @NotNull
    private String label;

    @NotNull
    public String getLabel() {
        return label;
    }

    public void setLabel(@NotNull String label) {
        this.label = label;
    }

    @NotNull
    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(@NotNull String topicArn) {
        this.topicArn = topicArn;
    }
}
