/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import java.io.Serializable;

/**
 * A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a topic's attributes, use GetTopicAttributes .
 */
public class Topic implements Serializable {

    private static final long serialVersionUID = -6802238700398888729L;
    /**
     * The topic's ARN.
     */
    private String topicArn;

    public Topic(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}
