/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.auth;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.auth.AWSCredentials;
import com.amazonaws.1.9.39.shade.auth.AWSCredentialsProvider;
import com.amazonaws.1.9.39.shade.auth.BasicAWSCredentials;
import com.amazonaws.1.9.39.shade.util.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    @Override
    public AWSCredentials getCredentials() {
        String accessKey = StringUtils.trim(System.getProperty("aws.accessKeyId"));
        String secretKey = StringUtils.trim(System.getProperty("aws.secretKey"));
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new AmazonClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

