/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.4.3.5.shade.conn.ClientConnectionManager;

public final class IdleConnectionReaper
extends Thread {
    private static final int PERIOD_MILLISECONDS = 60000;
    private static final ArrayList<ClientConnectionManager> connectionManagers = new ArrayList();
    private volatile boolean shuttingDown;
    private static IdleConnectionReaper instance;
    static final Log log;

    private IdleConnectionReaper() {
        super("java-sdk-http-connection-reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(ClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        return connectionManagers.add(connectionManager);
    }

    public static synchronized boolean removeConnectionManager(ClientConnectionManager connectionManager) {
        boolean b = connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
        return b;
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block6: while (true) {
            if (this.shuttingDown) {
                log.debug((Object)"Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(60000L);
                List connectionManagers = null;
                Class<IdleConnectionReaper> clazz = IdleConnectionReaper.class;
                // MONITORENTER : com.amazonaws.1.9.39.shade.http.IdleConnectionReaper.class
                connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
                // MONITOREXIT : clazz
                Iterator i$ = connectionManagers.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    ClientConnectionManager connectionManager = (ClientConnectionManager)i$.next();
                    try {
                        connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                    catch (Exception t) {
                        log.warn((Object)"Unable to close idle connections", (Throwable)t);
                    }
                }
            }
            catch (Throwable t) {
                log.debug((Object)"Reaper thread: ", t);
                continue;
            }
            break;
        }
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    static synchronized int size() {
        return connectionManagers.size();
    }

    static {
        log = LogFactory.getLog(IdleConnectionReaper.class);
    }
}

