/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.sqs.model.transform;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.DefaultRequest;
import com.amazonaws.1.9.39.shade.Request;
import com.amazonaws.1.9.39.shade.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.1.9.39.shade.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.1.9.39.shade.transform.Marshaller;
import com.amazonaws.1.9.39.shade.util.StringUtils;
import java.util.List;

public class DeleteMessageBatchRequestMarshaller
implements Marshaller<Request<DeleteMessageBatchRequest>, DeleteMessageBatchRequest> {
    @Override
    public Request<DeleteMessageBatchRequest> marshall(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteMessageBatchRequest> request = new DefaultRequest<DeleteMessageBatchRequest>(deleteMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteMessageBatch");
        request.addParameter("Version", "2012-11-05");
        if (deleteMessageBatchRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(deleteMessageBatchRequest.getQueueUrl()));
        }
        List<DeleteMessageBatchRequestEntry> entriesList = deleteMessageBatchRequest.getEntries();
        int entriesListIndex = 1;
        for (DeleteMessageBatchRequestEntry entriesListValue : entriesList) {
            DeleteMessageBatchRequestEntry deleteMessageBatchRequestEntryMember = entriesListValue;
            if (deleteMessageBatchRequestEntryMember != null) {
                if (deleteMessageBatchRequestEntryMember.getId() != null) {
                    request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString(deleteMessageBatchRequestEntryMember.getId()));
                }
                if (deleteMessageBatchRequestEntryMember.getReceiptHandle() != null) {
                    request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringUtils.fromString(deleteMessageBatchRequestEntryMember.getReceiptHandle()));
                }
            }
            ++entriesListIndex;
        }
        return request;
    }
}

