/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.impl.cookie;

import org.apache.http.4.3.5.shade.annotation.Immutable;
import org.apache.http.4.3.5.shade.cookie.Cookie;
import org.apache.http.4.3.5.shade.cookie.CookieOrigin;
import org.apache.http.4.3.5.shade.cookie.CookieRestrictionViolationException;
import org.apache.http.4.3.5.shade.cookie.MalformedCookieException;
import org.apache.http.4.3.5.shade.cookie.SetCookie;
import org.apache.http.4.3.5.shade.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.http.4.3.5.shade.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

