/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.4.3.5.shade.HttpClientConnection;
import org.apache.http.4.3.5.shade.HttpHost;
import org.apache.http.4.3.5.shade.annotation.ThreadSafe;
import org.apache.http.4.3.5.shade.config.ConnectionConfig;
import org.apache.http.4.3.5.shade.config.SocketConfig;
import org.apache.http.4.3.5.shade.impl.pool.BasicConnFactory;
import org.apache.http.4.3.5.shade.impl.pool.BasicPoolEntry;
import org.apache.http.4.3.5.shade.params.HttpParams;
import org.apache.http.4.3.5.shade.pool.AbstractConnPool;
import org.apache.http.4.3.5.shade.pool.ConnFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }
}

