/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns;

import com.amazonaws.1.9.39.shade.auth.BasicAWSCredentials;
import com.amazonaws.1.9.39.shade.services.sns.AmazonSNS;
import com.amazonaws.1.9.39.shade.services.sns.AmazonSNSClient;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.sns.model.RegionEndpoint;

public class Config {
    private AmazonSNS client;
    private String topicArn;
    private RegionEndpoint region;

    public void connect(String accessKey, String secretKey) throws ConnectionException {
        if (StringUtils.isBlank((String)accessKey) || StringUtils.isBlank((String)secretKey)) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "001", "Access Key or Secret Key is blank");
        }
        this.client = new AmazonSNSClient(new BasicAWSCredentials(accessKey, secretKey));
        if (this.region != null) {
            this.client.setEndpoint(this.region.value());
        }
    }

    public void testConnect(String accessKey, String secretKey) throws ConnectionException {
        this.connect(accessKey, secretKey);
        if (StringUtils.isBlank((String)this.topicArn)) {
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, "002", "Specify the ARN of the topic to test connectivity.");
        }
        try {
            this.client.getTopicAttributes(this.topicArn);
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage());
        }
    }

    public void disconnect() {
        this.setClient(null);
    }

    public boolean isConnected() {
        return this.getClient() != null;
    }

    public String connectionId() {
        return "amazon-sns-";
    }

    public AmazonSNS getClient() {
        return this.client;
    }

    public void setClient(AmazonSNS client) {
        this.client = client;
    }

    public RegionEndpoint getRegion() {
        return this.region;
    }

    public void setRegion(RegionEndpoint region) {
        this.region = region;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}

