/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns.util;

import com.amazonaws.1.9.39.shade.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.1.9.39.shade.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.1.9.39.shade.services.sns.model.ListTopicsResult;
import com.amazonaws.1.9.39.shade.services.sns.model.MessageAttributeValue;
import com.amazonaws.1.9.39.shade.services.sns.model.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.sns.model.ListSubscriptions;
import org.mule.modules.sns.model.ListSubscriptionsByTopic;
import org.mule.modules.sns.model.ListTopics;
import org.mule.modules.sns.model.MessageAttribute;
import org.mule.modules.sns.model.Subscription;

public class SNSModelFactory {
    private SNSModelFactory() {
    }

    public static ListSubscriptions getListSubscriptions(@NotNull ListSubscriptionsResult result) {
        ListSubscriptions listSubscriptions = new ListSubscriptions();
        listSubscriptions.setNextToken(result.getNextToken());
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(result.getSubscriptions().size());
        if (!result.getSubscriptions().isEmpty()) {
            for (com.amazonaws.1.9.39.shade.services.sns.model.Subscription subscription : result.getSubscriptions()) {
                Subscription local = new Subscription(subscription.getEndpoint(), subscription.getOwner(), subscription.getProtocol(), subscription.getSubscriptionArn(), subscription.getTopicArn());
                subscriptionList.add(local);
            }
        }
        listSubscriptions.setSubscriptions(subscriptionList);
        return listSubscriptions;
    }

    public static ListSubscriptionsByTopic getListSubscriptionsByTopic(@NotNull ListSubscriptionsByTopicResult result) {
        ListSubscriptionsByTopic listSubscriptionsByTopic = new ListSubscriptionsByTopic();
        listSubscriptionsByTopic.setNextToken(result.getNextToken());
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(result.getSubscriptions().size());
        if (!result.getSubscriptions().isEmpty()) {
            for (com.amazonaws.1.9.39.shade.services.sns.model.Subscription subscription : result.getSubscriptions()) {
                Subscription local = new Subscription(subscription.getEndpoint(), subscription.getOwner(), subscription.getProtocol(), subscription.getSubscriptionArn(), subscription.getTopicArn());
                subscriptionList.add(local);
            }
        }
        listSubscriptionsByTopic.setSubscriptions(subscriptionList);
        return listSubscriptionsByTopic;
    }

    public static ListTopics getListTopics(ListTopicsResult result) {
        ListTopics listTopics = new ListTopics();
        listTopics.setNextToken(result.getNextToken());
        ArrayList<org.mule.modules.sns.model.Topic> topicList = new ArrayList<org.mule.modules.sns.model.Topic>(result.getTopics().size());
        if (!result.getTopics().isEmpty()) {
            for (Topic topic : result.getTopics()) {
                org.mule.modules.sns.model.Topic local = new org.mule.modules.sns.model.Topic(topic.getTopicArn());
                topicList.add(local);
            }
        }
        listTopics.setTopics(topicList);
        return listTopics;
    }

    public static Map<String, MessageAttributeValue> getMessageAttributes(Map<String, MessageAttribute> messageAttributes) {
        HashMap<String, MessageAttributeValue> messageAttributeValueMap = new HashMap<String, MessageAttributeValue>();
        for (Map.Entry<String, MessageAttribute> attributeEntry : messageAttributes.entrySet()) {
            MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
            messageAttributeValue.setStringValue(attributeEntry.getValue().getStringValue());
            messageAttributeValue.setDataType(attributeEntry.getValue().getDataType());
            messageAttributeValueMap.put(attributeEntry.getKey(), messageAttributeValue);
        }
        return messageAttributeValueMap;
    }
}

