/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.ReadLimitInfo;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public abstract class AmazonWebServiceRequest
implements Cloneable,
ReadLimitInfo {
    public static final AmazonWebServiceRequest NOOP = new AmazonWebServiceRequest(){};
    private ProgressListener progressListener = ProgressListener.NOOP;
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private RequestMetricCollector requestMetricCollector;
    private AWSCredentials credentials;
    private Map<String, String> customRequestHeaders;

    public void setRequestCredentials(AWSCredentials credentials) {
        this.credentials = credentials;
    }

    public AWSCredentials getRequestCredentials() {
        return this.credentials;
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.requestMetricCollector = requestMetricCollector;
    }

    public <T extends AmazonWebServiceRequest> T withRequestMetricCollector(RequestMetricCollector metricCollector) {
        this.setRequestMetricCollector(metricCollector);
        AmazonWebServiceRequest t = this;
        return (T)t;
    }

    public void setGeneralProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? ProgressListener.NOOP : progressListener;
    }

    public ProgressListener getGeneralProgressListener() {
        return this.progressListener;
    }

    public <T extends AmazonWebServiceRequest> T withGeneralProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        AmazonWebServiceRequest t = this;
        return (T)t;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        return this.customRequestHeaders.put(name, value);
    }

    @Override
    public final int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }

    protected final <T extends AmazonWebServiceRequest> T copyBaseTo(T target) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, String> e : this.customRequestHeaders.entrySet()) {
                target.putCustomRequestHeader(e.getKey(), e.getValue());
            }
        }
        target.setRequestCredentials(this.credentials);
        target.setGeneralProgressListener(this.progressListener);
        target.setRequestMetricCollector(this.requestMetricCollector);
        this.requestClientOptions.copyTo(target.getRequestClientOptions());
        return target;
    }

    public AmazonWebServiceRequest clone() {
        try {
            return (AmazonWebServiceRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

