/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.auth.policy.conditions;

import com.amazonaws.1.10.1.shade.auth.policy.Condition;
import com.amazonaws.1.10.1.shade.auth.policy.conditions.StringCondition;

public class SNSConditionFactory {
    public static final String ENDPOINT_CONDITION_KEY = "sns:Endpoint";
    public static final String PROTOCOL_CONDITION_KEY = "sns:Protocol";

    private SNSConditionFactory() {
    }

    public static Condition newEndpointCondition(String endpointPattern) {
        return new StringCondition(StringCondition.StringComparisonType.StringLike, ENDPOINT_CONDITION_KEY, endpointPattern);
    }

    public static Condition newProtocolCondition(String protocol) {
        return new StringCondition(StringCondition.StringComparisonType.StringEquals, PROTOCOL_CONDITION_KEY, protocol);
    }
}

