/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.auth.profile;

import com.amazonaws.1.10.1.shade.auth.AWSCredentials;
import com.amazonaws.1.10.1.shade.auth.AWSCredentialsProvider;
import com.amazonaws.1.10.1.shade.auth.profile.ProfilesConfigFile;
import com.amazonaws.1.10.1.shade.util.StringUtils;

public class ProfileCredentialsProvider
implements AWSCredentialsProvider {
    private volatile ProfilesConfigFile profilesConfigFile;
    private final String profileName;

    public ProfileCredentialsProvider() {
        this(null);
    }

    public ProfileCredentialsProvider(String profileName) {
        this((ProfilesConfigFile)null, profileName);
    }

    public ProfileCredentialsProvider(String profilesConfigFilePath, String profileName) {
        this(new ProfilesConfigFile(profilesConfigFilePath), profileName);
    }

    public ProfileCredentialsProvider(ProfilesConfigFile profilesConfigFile, String profileName) {
        this.profilesConfigFile = profilesConfigFile;
        if (profileName == null) {
            String profileEnvVarOverride = System.getenv("AWS_PROFILE");
            if (!StringUtils.isNullOrEmpty(profileEnvVarOverride = StringUtils.trim(profileEnvVarOverride))) {
                this.profileName = profileEnvVarOverride;
            } else {
                String profileSysPropOverride = System.getProperty("aws.profile");
                this.profileName = !StringUtils.isNullOrEmpty(profileSysPropOverride = StringUtils.trim(profileSysPropOverride)) ? profileSysPropOverride : "default";
            }
        } else {
            this.profileName = profileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials getCredentials() {
        if (this.profilesConfigFile == null) {
            ProfileCredentialsProvider profileCredentialsProvider = this;
            synchronized (profileCredentialsProvider) {
                if (this.profilesConfigFile == null) {
                    this.profilesConfigFile = new ProfilesConfigFile();
                }
            }
        }
        return this.profilesConfigFile.getCredentials(this.profileName);
    }

    @Override
    public void refresh() {
    }
}

