/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.auth.profile.internal;

import com.amazonaws.1.10.1.shade.auth.AWSCredentials;
import com.amazonaws.1.10.1.shade.auth.AWSSessionCredentials;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.4.3.5.shade.annotation.Immutable;

@Immutable
public class Profile {
    static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    static final String AWS_SESSION_TOKEN = "aws_session_token";
    private final String profileName;
    private final AWSCredentials awsCredentials;

    public Profile(String profileName, AWSCredentials awsCredentials) {
        this.profileName = profileName;
        this.awsCredentials = awsCredentials;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public AWSCredentials getCredentials() {
        return this.awsCredentials;
    }

    public Map<String, String> getProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put(AWS_ACCESS_KEY_ID, this.awsCredentials.getAWSAccessKeyId());
        properties.put(AWS_SECRET_ACCESS_KEY, this.awsCredentials.getAWSSecretKey());
        if (this.awsCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials sessionCred = (AWSSessionCredentials)this.awsCredentials;
            properties.put(AWS_SESSION_TOKEN, sessionCred.getSessionToken());
        }
        return properties;
    }

    public String getPropertyValue(String propertyName) {
        return this.getProperties().get(propertyName);
    }
}

