/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.http;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.AmazonServiceException;
import com.amazonaws.1.10.1.shade.http.HttpResponse;
import com.amazonaws.1.10.1.shade.http.HttpResponseHandler;
import com.amazonaws.1.10.1.shade.transform.JsonErrorUnmarshaller;
import com.amazonaws.1.10.1.shade.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    private List<? extends JsonErrorUnmarshaller> unmarshallerList;

    public JsonErrorResponseHandler(List<? extends JsonErrorUnmarshaller> exceptionUnmarshallers) {
        this.unmarshallerList = exceptionUnmarshallers;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JSONObject jsonErrorMessage;
        String streamContents = this.readStreamContents(response.getContent());
        try {
            String s = streamContents;
            if (s.length() == 0 || s.trim().length() == 0) {
                s = "{}";
            }
            jsonErrorMessage = new JSONObject(s);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to parse error response: '" + streamContents + "'", e);
        }
        String errorTypeFromHeader = this.parseErrorTypeFromHeader(response);
        AmazonServiceException ase = this.runErrorUnmarshallers(response, jsonErrorMessage, errorTypeFromHeader);
        if (ase == null) {
            return null;
        }
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        if (response.getStatusCode() < 500) {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        } else {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        }
        for (Map.Entry<String, String> headerEntry : response.getHeaders().entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("X-Amzn-RequestId")) continue;
            ase.setRequestId(headerEntry.getValue());
        }
        return ase;
    }

    private AmazonServiceException runErrorUnmarshallers(HttpResponse errorResponse, JSONObject json, String errorTypeFromHeader) throws Exception {
        for (JsonErrorUnmarshaller jsonErrorUnmarshaller : this.unmarshallerList) {
            if (!jsonErrorUnmarshaller.match(errorTypeFromHeader, json)) continue;
            AmazonServiceException ase = jsonErrorUnmarshaller.unmarshall(json);
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private String readStreamContents(InputStream stream) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception e) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AmazonClientException("Unable to read error response: " + e.getMessage(), e);
        }
    }

    private String parseErrorTypeFromHeader(HttpResponse response) {
        int separator;
        String headerValue = response.getHeaders().get(X_AMZN_ERROR_TYPE);
        if (headerValue != null && (separator = headerValue.indexOf(58)) != -1) {
            headerValue = headerValue.substring(0, separator);
        }
        return headerValue;
    }
}

