/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sns;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.AmazonServiceException;
import com.amazonaws.1.10.1.shade.AmazonWebServiceClient;
import com.amazonaws.1.10.1.shade.AmazonWebServiceRequest;
import com.amazonaws.1.10.1.shade.ClientConfiguration;
import com.amazonaws.1.10.1.shade.Request;
import com.amazonaws.1.10.1.shade.Response;
import com.amazonaws.1.10.1.shade.ResponseMetadata;
import com.amazonaws.1.10.1.shade.auth.AWSCredentials;
import com.amazonaws.1.10.1.shade.auth.AWSCredentialsProvider;
import com.amazonaws.1.10.1.shade.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.1.10.1.shade.handlers.HandlerChainFactory;
import com.amazonaws.1.10.1.shade.http.DefaultErrorResponseHandler;
import com.amazonaws.1.10.1.shade.http.ExecutionContext;
import com.amazonaws.1.10.1.shade.http.StaxResponseHandler;
import com.amazonaws.1.10.1.shade.internal.StaticCredentialsProvider;
import com.amazonaws.1.10.1.shade.metrics.RequestMetricCollector;
import com.amazonaws.1.10.1.shade.services.sns.AmazonSNS;
import com.amazonaws.1.10.1.shade.services.sns.model.AddPermissionRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.1.10.1.shade.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.CreatePlatformApplicationResult;
import com.amazonaws.1.10.1.shade.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.1.10.1.shade.services.sns.model.CreateTopicRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.CreateTopicResult;
import com.amazonaws.1.10.1.shade.services.sns.model.DeleteEndpointRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.DeletePlatformApplicationRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.DeleteTopicRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetEndpointAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetEndpointAttributesResult;
import com.amazonaws.1.10.1.shade.services.sns.model.GetPlatformApplicationAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetPlatformApplicationAttributesResult;
import com.amazonaws.1.10.1.shade.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.1.10.1.shade.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.1.10.1.shade.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListEndpointsByPlatformApplicationResult;
import com.amazonaws.1.10.1.shade.services.sns.model.ListPlatformApplicationsRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListPlatformApplicationsResult;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.1.10.1.shade.services.sns.model.ListTopicsRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListTopicsResult;
import com.amazonaws.1.10.1.shade.services.sns.model.PublishRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.PublishResult;
import com.amazonaws.1.10.1.shade.services.sns.model.RemovePermissionRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SubscribeRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SubscribeResult;
import com.amazonaws.1.10.1.shade.services.sns.model.UnsubscribeRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.AuthorizationErrorExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ConfirmSubscriptionRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ConfirmSubscriptionResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.CreatePlatformApplicationRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.CreatePlatformApplicationResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.CreatePlatformEndpointRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.CreatePlatformEndpointResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.CreateTopicRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.CreateTopicResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.DeleteEndpointRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.DeletePlatformApplicationRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.DeleteTopicRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.EndpointDisabledExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetEndpointAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetEndpointAttributesResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetPlatformApplicationAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetPlatformApplicationAttributesResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetSubscriptionAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetSubscriptionAttributesResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetTopicAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.GetTopicAttributesResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListEndpointsByPlatformApplicationResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListPlatformApplicationsRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListPlatformApplicationsResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListSubscriptionsByTopicRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListSubscriptionsByTopicResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListSubscriptionsRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListSubscriptionsResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListTopicsRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.ListTopicsResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.PlatformApplicationDisabledExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.PublishRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.PublishResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SetEndpointAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SetPlatformApplicationAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SetSubscriptionAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SetTopicAttributesRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SubscribeRequestMarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SubscribeResultStaxUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.SubscriptionLimitExceededExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.TopicLimitExceededExceptionUnmarshaller;
import com.amazonaws.1.10.1.shade.services.sns.model.transform.UnsubscribeRequestMarshaller;
import com.amazonaws.1.10.1.shade.transform.StandardErrorUnmarshaller;
import com.amazonaws.1.10.1.shade.transform.StaxUnmarshallerContext;
import com.amazonaws.1.10.1.shade.transform.Unmarshaller;
import com.amazonaws.1.10.1.shade.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class AmazonSNSClient
extends AmazonWebServiceClient
implements AmazonSNS {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonSNSClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSNSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSNSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSNSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new TopicLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EndpointDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PlatformApplicationDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubscriptionLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("sns.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/1/10/1/shade/services/sns/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/1/10/1/shade/services/sns/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmSubscriptionResult confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmSubscriptionRequest> request = null;
        Response<ConfirmSubscriptionResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmSubscriptionRequestMarshaller().marshall(super.beforeMarshalling(confirmSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ConfirmSubscriptionResultStaxUnmarshaller(), executionContext);
            ConfirmSubscriptionResult confirmSubscriptionResult = response.getAwsResponse();
            return confirmSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlatformApplicationResult createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPlatformApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlatformApplicationRequest> request = null;
        Response<CreatePlatformApplicationResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePlatformApplicationRequestMarshaller().marshall(super.beforeMarshalling(createPlatformApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreatePlatformApplicationResultStaxUnmarshaller(), executionContext);
            CreatePlatformApplicationResult createPlatformApplicationResult = response.getAwsResponse();
            return createPlatformApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTopicAttributesResult getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTopicAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTopicAttributesRequest> request = null;
        Response<GetTopicAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTopicAttributesRequestMarshaller().marshall(super.beforeMarshalling(getTopicAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetTopicAttributesResultStaxUnmarshaller(), executionContext);
            GetTopicAttributesResult getTopicAttributesResult = response.getAwsResponse();
            return getTopicAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeResult subscribe(SubscribeRequest subscribeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(subscribeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeRequest> request = null;
        Response<SubscribeResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeRequestMarshaller().marshall(super.beforeMarshalling(subscribeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new SubscribeResultStaxUnmarshaller(), executionContext);
            SubscribeResult subscribeResult = response.getAwsResponse();
            return subscribeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteEndpointRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEndpointRequestMarshaller().marshall(super.beforeMarshalling(deleteEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTopicAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetTopicAttributesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTopicAttributesRequestMarshaller().marshall(super.beforeMarshalling(setTopicAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RemovePermissionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestMarshaller().marshall(super.beforeMarshalling(removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEndpointAttributesResult getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEndpointAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEndpointAttributesRequest> request = null;
        Response<GetEndpointAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEndpointAttributesRequestMarshaller().marshall(super.beforeMarshalling(getEndpointAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetEndpointAttributesResultStaxUnmarshaller(), executionContext);
            GetEndpointAttributesResult getEndpointAttributesResult = response.getAwsResponse();
            return getEndpointAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscriptionsResult listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSubscriptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSubscriptionsRequest> request = null;
        Response<ListSubscriptionsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSubscriptionsRequestMarshaller().marshall(super.beforeMarshalling(listSubscriptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListSubscriptionsResultStaxUnmarshaller(), executionContext);
            ListSubscriptionsResult listSubscriptionsResult = response.getAwsResponse();
            return listSubscriptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlatformEndpointResult createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPlatformEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlatformEndpointRequest> request = null;
        Response<CreatePlatformEndpointResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePlatformEndpointRequestMarshaller().marshall(super.beforeMarshalling(createPlatformEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreatePlatformEndpointResultStaxUnmarshaller(), executionContext);
            CreatePlatformEndpointResult createPlatformEndpointResult = response.getAwsResponse();
            return createPlatformEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setSubscriptionAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetSubscriptionAttributesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetSubscriptionAttributesRequestMarshaller().marshall(super.beforeMarshalling(setSubscriptionAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTopicResult createTopic(CreateTopicRequest createTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTopicRequest> request = null;
        Response<CreateTopicResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTopicRequestMarshaller().marshall(super.beforeMarshalling(createTopicRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new CreateTopicResultStaxUnmarshaller(), executionContext);
            CreateTopicResult createTopicResult = response.getAwsResponse();
            return createTopicResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriptionAttributesResult getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSubscriptionAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSubscriptionAttributesRequest> request = null;
        Response<GetSubscriptionAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSubscriptionAttributesRequestMarshaller().marshall(super.beforeMarshalling(getSubscriptionAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetSubscriptionAttributesResultStaxUnmarshaller(), executionContext);
            GetSubscriptionAttributesResult getSubscriptionAttributesResult = response.getAwsResponse();
            return getSubscriptionAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTopicsResult listTopics(ListTopicsRequest listTopicsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTopicsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTopicsRequest> request = null;
        Response<ListTopicsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTopicsRequestMarshaller().marshall(super.beforeMarshalling(listTopicsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListTopicsResultStaxUnmarshaller(), executionContext);
            ListTopicsResult listTopicsResult = response.getAwsResponse();
            return listTopicsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePlatformApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeletePlatformApplicationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePlatformApplicationRequestMarshaller().marshall(super.beforeMarshalling(deletePlatformApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPlatformApplicationsResult listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPlatformApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPlatformApplicationsRequest> request = null;
        Response<ListPlatformApplicationsResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPlatformApplicationsRequestMarshaller().marshall(super.beforeMarshalling(listPlatformApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListPlatformApplicationsResultStaxUnmarshaller(), executionContext);
            ListPlatformApplicationsResult listPlatformApplicationsResult = response.getAwsResponse();
            return listPlatformApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setEndpointAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetEndpointAttributesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetEndpointAttributesRequestMarshaller().marshall(super.beforeMarshalling(setEndpointAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(UnsubscribeRequest unsubscribeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UnsubscribeRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeRequestMarshaller().marshall(super.beforeMarshalling(unsubscribeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTopic(DeleteTopicRequest deleteTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteTopicRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTopicRequestMarshaller().marshall(super.beforeMarshalling(deleteTopicRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPlatformApplicationAttributesResult getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPlatformApplicationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPlatformApplicationAttributesRequest> request = null;
        Response<GetPlatformApplicationAttributesResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPlatformApplicationAttributesRequestMarshaller().marshall(super.beforeMarshalling(getPlatformApplicationAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new GetPlatformApplicationAttributesResultStaxUnmarshaller(), executionContext);
            GetPlatformApplicationAttributesResult getPlatformApplicationAttributesResult = response.getAwsResponse();
            return getPlatformApplicationAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setPlatformApplicationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetPlatformApplicationAttributesRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetPlatformApplicationAttributesRequestMarshaller().marshall(super.beforeMarshalling(setPlatformApplicationAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermission(AddPermissionRequest addPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<AddPermissionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddPermissionRequestMarshaller().marshall(super.beforeMarshalling(addPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointsByPlatformApplicationResult listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEndpointsByPlatformApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEndpointsByPlatformApplicationRequest> request = null;
        Response<ListEndpointsByPlatformApplicationResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEndpointsByPlatformApplicationRequestMarshaller().marshall(super.beforeMarshalling(listEndpointsByPlatformApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListEndpointsByPlatformApplicationResultStaxUnmarshaller(), executionContext);
            ListEndpointsByPlatformApplicationResult listEndpointsByPlatformApplicationResult = response.getAwsResponse();
            return listEndpointsByPlatformApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSubscriptionsByTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSubscriptionsByTopicRequest> request = null;
        Response<ListSubscriptionsByTopicResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSubscriptionsByTopicRequestMarshaller().marshall(super.beforeMarshalling(listSubscriptionsByTopicRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new ListSubscriptionsByTopicResultStaxUnmarshaller(), executionContext);
            ListSubscriptionsByTopicResult listSubscriptionsByTopicResult = response.getAwsResponse();
            return listSubscriptionsByTopicResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishResult publish(PublishRequest publishRequest) {
        ExecutionContext executionContext = this.createExecutionContext(publishRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PublishRequest> request = null;
        Response<PublishResult> response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PublishRequestMarshaller().marshall(super.beforeMarshalling(publishRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, new PublishResultStaxUnmarshaller(), executionContext);
            PublishResult publishResult = response.getAwsResponse();
            return publishResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSubscriptionsResult listSubscriptions() throws AmazonServiceException, AmazonClientException {
        return this.listSubscriptions(new ListSubscriptionsRequest());
    }

    @Override
    public ListTopicsResult listTopics() throws AmazonServiceException, AmazonClientException {
        return this.listTopics(new ListTopicsRequest());
    }

    @Override
    public ListPlatformApplicationsResult listPlatformApplications() throws AmazonServiceException, AmazonClientException {
        return this.listPlatformApplications(new ListPlatformApplicationsRequest());
    }

    @Override
    public ConfirmSubscriptionResult confirmSubscription(String topicArn, String token, String authenticateOnUnsubscribe) {
        ConfirmSubscriptionRequest confirmSubscriptionRequest = new ConfirmSubscriptionRequest();
        confirmSubscriptionRequest.setTopicArn(topicArn);
        confirmSubscriptionRequest.setToken(token);
        confirmSubscriptionRequest.setAuthenticateOnUnsubscribe(authenticateOnUnsubscribe);
        return this.confirmSubscription(confirmSubscriptionRequest);
    }

    @Override
    public ConfirmSubscriptionResult confirmSubscription(String topicArn, String token) {
        ConfirmSubscriptionRequest confirmSubscriptionRequest = new ConfirmSubscriptionRequest();
        confirmSubscriptionRequest.setTopicArn(topicArn);
        confirmSubscriptionRequest.setToken(token);
        return this.confirmSubscription(confirmSubscriptionRequest);
    }

    @Override
    public GetTopicAttributesResult getTopicAttributes(String topicArn) {
        GetTopicAttributesRequest getTopicAttributesRequest = new GetTopicAttributesRequest();
        getTopicAttributesRequest.setTopicArn(topicArn);
        return this.getTopicAttributes(getTopicAttributesRequest);
    }

    @Override
    public SubscribeResult subscribe(String topicArn, String protocol, String endpoint) {
        SubscribeRequest subscribeRequest = new SubscribeRequest();
        subscribeRequest.setTopicArn(topicArn);
        subscribeRequest.setProtocol(protocol);
        subscribeRequest.setEndpoint(endpoint);
        return this.subscribe(subscribeRequest);
    }

    @Override
    public void setTopicAttributes(String topicArn, String attributeName, String attributeValue) {
        SetTopicAttributesRequest setTopicAttributesRequest = new SetTopicAttributesRequest();
        setTopicAttributesRequest.setTopicArn(topicArn);
        setTopicAttributesRequest.setAttributeName(attributeName);
        setTopicAttributesRequest.setAttributeValue(attributeValue);
        this.setTopicAttributes(setTopicAttributesRequest);
    }

    @Override
    public void removePermission(String topicArn, String label) {
        RemovePermissionRequest removePermissionRequest = new RemovePermissionRequest();
        removePermissionRequest.setTopicArn(topicArn);
        removePermissionRequest.setLabel(label);
        this.removePermission(removePermissionRequest);
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(String nextToken) {
        ListSubscriptionsRequest listSubscriptionsRequest = new ListSubscriptionsRequest();
        listSubscriptionsRequest.setNextToken(nextToken);
        return this.listSubscriptions(listSubscriptionsRequest);
    }

    @Override
    public void setSubscriptionAttributes(String subscriptionArn, String attributeName, String attributeValue) {
        SetSubscriptionAttributesRequest setSubscriptionAttributesRequest = new SetSubscriptionAttributesRequest();
        setSubscriptionAttributesRequest.setSubscriptionArn(subscriptionArn);
        setSubscriptionAttributesRequest.setAttributeName(attributeName);
        setSubscriptionAttributesRequest.setAttributeValue(attributeValue);
        this.setSubscriptionAttributes(setSubscriptionAttributesRequest);
    }

    @Override
    public CreateTopicResult createTopic(String name) {
        CreateTopicRequest createTopicRequest = new CreateTopicRequest();
        createTopicRequest.setName(name);
        return this.createTopic(createTopicRequest);
    }

    @Override
    public GetSubscriptionAttributesResult getSubscriptionAttributes(String subscriptionArn) {
        GetSubscriptionAttributesRequest getSubscriptionAttributesRequest = new GetSubscriptionAttributesRequest();
        getSubscriptionAttributesRequest.setSubscriptionArn(subscriptionArn);
        return this.getSubscriptionAttributes(getSubscriptionAttributesRequest);
    }

    @Override
    public ListTopicsResult listTopics(String nextToken) {
        ListTopicsRequest listTopicsRequest = new ListTopicsRequest();
        listTopicsRequest.setNextToken(nextToken);
        return this.listTopics(listTopicsRequest);
    }

    @Override
    public void unsubscribe(String subscriptionArn) {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest();
        unsubscribeRequest.setSubscriptionArn(subscriptionArn);
        this.unsubscribe(unsubscribeRequest);
    }

    @Override
    public void deleteTopic(String topicArn) {
        DeleteTopicRequest deleteTopicRequest = new DeleteTopicRequest();
        deleteTopicRequest.setTopicArn(topicArn);
        this.deleteTopic(deleteTopicRequest);
    }

    @Override
    public void addPermission(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames) {
        AddPermissionRequest addPermissionRequest = new AddPermissionRequest();
        addPermissionRequest.setTopicArn(topicArn);
        addPermissionRequest.setLabel(label);
        addPermissionRequest.setAWSAccountIds(aWSAccountIds);
        addPermissionRequest.setActionNames(actionNames);
        this.addPermission(addPermissionRequest);
    }

    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(String topicArn, String nextToken) {
        ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest = new ListSubscriptionsByTopicRequest();
        listSubscriptionsByTopicRequest.setTopicArn(topicArn);
        listSubscriptionsByTopicRequest.setNextToken(nextToken);
        return this.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
    }

    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(String topicArn) {
        ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest = new ListSubscriptionsByTopicRequest();
        listSubscriptionsByTopicRequest.setTopicArn(topicArn);
        return this.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
    }

    @Override
    public PublishResult publish(String topicArn, String message) {
        PublishRequest publishRequest = new PublishRequest();
        publishRequest.setTopicArn(topicArn);
        publishRequest.setMessage(message);
        return this.publish(publishRequest);
    }

    @Override
    public PublishResult publish(String topicArn, String message, String subject) {
        PublishRequest publishRequest = new PublishRequest();
        publishRequest.setTopicArn(topicArn);
        publishRequest.setMessage(message);
        publishRequest.setSubject(subject);
        return this.publish(publishRequest);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

