/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sns.model.transform;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.DefaultRequest;
import com.amazonaws.1.10.1.shade.Request;
import com.amazonaws.1.10.1.shade.services.sns.model.SubscribeRequest;
import com.amazonaws.1.10.1.shade.transform.Marshaller;
import com.amazonaws.1.10.1.shade.util.StringUtils;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    @Override
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        if (subscribeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubscribeRequest> request = new DefaultRequest<SubscribeRequest>(subscribeRequest, "AmazonSNS");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        if (subscribeRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(subscribeRequest.getTopicArn()));
        }
        if (subscribeRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(subscribeRequest.getProtocol()));
        }
        if (subscribeRequest.getEndpoint() != null) {
            request.addParameter("Endpoint", StringUtils.fromString(subscribeRequest.getEndpoint()));
        }
        return request;
    }
}

