/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sqs;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.AmazonServiceException;
import com.amazonaws.1.10.1.shade.ClientConfiguration;
import com.amazonaws.1.10.1.shade.auth.AWSCredentials;
import com.amazonaws.1.10.1.shade.auth.AWSCredentialsProvider;
import com.amazonaws.1.10.1.shade.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.1.10.1.shade.handlers.AsyncHandler;
import com.amazonaws.1.10.1.shade.services.sqs.AmazonSQSAsync;
import com.amazonaws.1.10.1.shade.services.sqs.AmazonSQSClient;
import com.amazonaws.1.10.1.shade.services.sqs.model.AddPermissionRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.CreateQueueRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.CreateQueueResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.ListQueuesRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.ListQueuesResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.SendMessageRequest;
import com.amazonaws.1.10.1.shade.services.sqs.model.SendMessageResult;
import com.amazonaws.1.10.1.shade.services.sqs.model.SetQueueAttributesRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonSQSAsyncClient
extends AmazonSQSClient
implements AmazonSQSAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonSQSAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSQSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> setQueueAttributesAsync(final SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.setQueueAttributes(setQueueAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setQueueAttributesAsync(final SetQueueAttributesRequest setQueueAttributesRequest, final AsyncHandler<SetQueueAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.setQueueAttributes(setQueueAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setQueueAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(final ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeMessageVisibilityBatchResult>(){

            @Override
            public ChangeMessageVisibilityBatchResult call() throws Exception {
                return AmazonSQSAsyncClient.this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
            }
        });
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(final ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest, final AsyncHandler<ChangeMessageVisibilityBatchRequest, ChangeMessageVisibilityBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeMessageVisibilityBatchResult>(){

            @Override
            public ChangeMessageVisibilityBatchResult call() throws Exception {
                ChangeMessageVisibilityBatchResult result;
                try {
                    result = AmazonSQSAsyncClient.this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(changeMessageVisibilityBatchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> changeMessageVisibilityAsync(final ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.changeMessageVisibility(changeMessageVisibilityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> changeMessageVisibilityAsync(final ChangeMessageVisibilityRequest changeMessageVisibilityRequest, final AsyncHandler<ChangeMessageVisibilityRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.changeMessageVisibility(changeMessageVisibilityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(changeMessageVisibilityRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(final GetQueueUrlRequest getQueueUrlRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueUrlResult>(){

            @Override
            public GetQueueUrlResult call() throws Exception {
                return AmazonSQSAsyncClient.this.getQueueUrl(getQueueUrlRequest);
            }
        });
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(final GetQueueUrlRequest getQueueUrlRequest, final AsyncHandler<GetQueueUrlRequest, GetQueueUrlResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueUrlResult>(){

            @Override
            public GetQueueUrlResult call() throws Exception {
                GetQueueUrlResult result;
                try {
                    result = AmazonSQSAsyncClient.this.getQueueUrl(getQueueUrlRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getQueueUrlRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.removePermission(removePermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest, final AsyncHandler<RemovePermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.removePermission(removePermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(removePermissionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(final GetQueueAttributesRequest getQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueAttributesResult>(){

            @Override
            public GetQueueAttributesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.getQueueAttributes(getQueueAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(final GetQueueAttributesRequest getQueueAttributesRequest, final AsyncHandler<GetQueueAttributesRequest, GetQueueAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueAttributesResult>(){

            @Override
            public GetQueueAttributesResult call() throws Exception {
                GetQueueAttributesResult result;
                try {
                    result = AmazonSQSAsyncClient.this.getQueueAttributes(getQueueAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getQueueAttributesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(final SendMessageBatchRequest sendMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageBatchResult>(){

            @Override
            public SendMessageBatchResult call() throws Exception {
                return AmazonSQSAsyncClient.this.sendMessageBatch(sendMessageBatchRequest);
            }
        });
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(final SendMessageBatchRequest sendMessageBatchRequest, final AsyncHandler<SendMessageBatchRequest, SendMessageBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageBatchResult>(){

            @Override
            public SendMessageBatchResult call() throws Exception {
                SendMessageBatchResult result;
                try {
                    result = AmazonSQSAsyncClient.this.sendMessageBatch(sendMessageBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(sendMessageBatchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> purgeQueueAsync(final PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.purgeQueue(purgeQueueRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> purgeQueueAsync(final PurgeQueueRequest purgeQueueRequest, final AsyncHandler<PurgeQueueRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.purgeQueue(purgeQueueRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(purgeQueueRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(final ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDeadLetterSourceQueuesResult>(){

            @Override
            public ListDeadLetterSourceQueuesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
            }
        });
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(final ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest, final AsyncHandler<ListDeadLetterSourceQueuesRequest, ListDeadLetterSourceQueuesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDeadLetterSourceQueuesResult>(){

            @Override
            public ListDeadLetterSourceQueuesResult call() throws Exception {
                ListDeadLetterSourceQueuesResult result;
                try {
                    result = AmazonSQSAsyncClient.this.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listDeadLetterSourceQueuesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteQueueAsync(final DeleteQueueRequest deleteQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.deleteQueue(deleteQueueRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteQueueAsync(final DeleteQueueRequest deleteQueueRequest, final AsyncHandler<DeleteQueueRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.deleteQueue(deleteQueueRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteQueueRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(final SendMessageRequest sendMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageResult>(){

            @Override
            public SendMessageResult call() throws Exception {
                return AmazonSQSAsyncClient.this.sendMessage(sendMessageRequest);
            }
        });
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(final SendMessageRequest sendMessageRequest, final AsyncHandler<SendMessageRequest, SendMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageResult>(){

            @Override
            public SendMessageResult call() throws Exception {
                SendMessageResult result;
                try {
                    result = AmazonSQSAsyncClient.this.sendMessage(sendMessageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(sendMessageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(final ReceiveMessageRequest receiveMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReceiveMessageResult>(){

            @Override
            public ReceiveMessageResult call() throws Exception {
                return AmazonSQSAsyncClient.this.receiveMessage(receiveMessageRequest);
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(final ReceiveMessageRequest receiveMessageRequest, final AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReceiveMessageResult>(){

            @Override
            public ReceiveMessageResult call() throws Exception {
                ReceiveMessageResult result;
                try {
                    result = AmazonSQSAsyncClient.this.receiveMessage(receiveMessageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(receiveMessageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(final ListQueuesRequest listQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.listQueues(listQueuesRequest);
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(final ListQueuesRequest listQueuesRequest, final AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                ListQueuesResult result;
                try {
                    result = AmazonSQSAsyncClient.this.listQueues(listQueuesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listQueuesRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(final DeleteMessageBatchRequest deleteMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteMessageBatchResult>(){

            @Override
            public DeleteMessageBatchResult call() throws Exception {
                return AmazonSQSAsyncClient.this.deleteMessageBatch(deleteMessageBatchRequest);
            }
        });
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(final DeleteMessageBatchRequest deleteMessageBatchRequest, final AsyncHandler<DeleteMessageBatchRequest, DeleteMessageBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteMessageBatchResult>(){

            @Override
            public DeleteMessageBatchResult call() throws Exception {
                DeleteMessageBatchResult result;
                try {
                    result = AmazonSQSAsyncClient.this.deleteMessageBatch(deleteMessageBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteMessageBatchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(final CreateQueueRequest createQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                return AmazonSQSAsyncClient.this.createQueue(createQueueRequest);
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(final CreateQueueRequest createQueueRequest, final AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                CreateQueueResult result;
                try {
                    result = AmazonSQSAsyncClient.this.createQueue(createQueueRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createQueueRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.addPermission(addPermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest, final AsyncHandler<AddPermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.addPermission(addPermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(addPermissionRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMessageAsync(final DeleteMessageRequest deleteMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.deleteMessage(deleteMessageRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMessageAsync(final DeleteMessageRequest deleteMessageRequest, final AsyncHandler<DeleteMessageRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSQSAsyncClient.this.deleteMessage(deleteMessageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteMessageRequest, null);
                return null;
            }
        });
    }
}

