/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sqs;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.Request;
import com.amazonaws.1.10.1.shade.handlers.AbstractRequestHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

public class QueueUrlHandler
extends AbstractRequestHandler {
    private static final String QUEUE_URL_PARAMETER = "QueueUrl";

    @Override
    public void beforeRequest(Request<?> request) {
        Map<String, List<String>> requestParams = request.getParameters();
        List<String> queueURLParam = requestParams.get(QUEUE_URL_PARAMETER);
        if (queueURLParam != null && !queueURLParam.isEmpty()) {
            List<String> queueURLParameter = requestParams.remove(QUEUE_URL_PARAMETER);
            String queueUrl = queueURLParameter.iterator().next();
            try {
                URI uri = new URI(queueUrl);
                request.setResourcePath(uri.getPath());
                if (uri.getHost() != null) {
                    URI uriWithoutPath = new URI(uri.toString().replace(uri.getPath(), ""));
                    request.setEndpoint(uriWithoutPath);
                }
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse SQS queue URL '" + queueUrl + "'", e);
            }
        }
    }
}

