/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sqs.buffered;

import com.amazonaws.1.10.1.shade.AmazonClientException;

public class QueueBufferConfig {
    public static final int MAX_BATCH_SIZE_DEFAULT = 10;
    private int maxBatchSize;
    public static final long SERVICE_MAX_BATCH_SIZE_BYTES = 262143L;
    private long maxBatchOpenMs;
    public static final long MAX_BATCH_OPEN_MS_DEFAULT = 200L;
    private boolean longPoll;
    private static final boolean LONG_POLL_DEFAULT = true;
    private int maxInflightOutboundBatches;
    public static final int MAX_INFLIGHT_OUTBOUND_BATCHES_DEFAULT = 5;
    private int maxInflightReceiveBatches;
    public static final int MAX_INFLIGHT_RECEIVE_BATCHES_DEFAULT = 10;
    private int maxDoneReceiveBatches;
    public static final int MAX_DONE_RECEIVE_BATCHES_DEFAULT = 10;
    private long maxBatchSizeBytes;
    public static final long MAX_BATCH_SIZE_BYTES_DEFAULT = 262143L;
    private int visibilityTimeoutSeconds;
    public static final int VISIBILITY_TIMEOUT_SECONDS_DEFAULT = -1;
    private int longPollWaitTimeoutSeconds;
    public static final int LONGPOLL_WAIT_TIMEOUT_SECONDS_DEFAULT = 20;

    public QueueBufferConfig(long maxBatchOpenMs, int maxInflightOutboundBatches, int maxInflightReceiveBatches, int maxDoneReceiveBatches, boolean paramLongPoll, long maxBatchSizeBytes, int visibilityTimeout, int longPollTimeout, int maxBatch) {
        this.maxBatchOpenMs = maxBatchOpenMs;
        this.maxInflightOutboundBatches = maxInflightOutboundBatches;
        this.maxInflightReceiveBatches = maxInflightReceiveBatches;
        this.maxDoneReceiveBatches = maxDoneReceiveBatches;
        this.longPoll = paramLongPoll;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.visibilityTimeoutSeconds = visibilityTimeout;
        this.longPollWaitTimeoutSeconds = longPollTimeout;
        this.maxBatchSize = maxBatch;
    }

    public QueueBufferConfig() {
        this(200L, 5, 10, 10, true, 262143L, -1, 20, 10);
    }

    public QueueBufferConfig(QueueBufferConfig other) {
        this.longPoll = other.longPoll;
        this.longPollWaitTimeoutSeconds = other.longPollWaitTimeoutSeconds;
        this.maxBatchOpenMs = other.maxBatchOpenMs;
        this.maxBatchSize = other.maxBatchSize;
        this.maxBatchSizeBytes = other.maxBatchSizeBytes;
        this.maxDoneReceiveBatches = other.maxDoneReceiveBatches;
        this.maxInflightOutboundBatches = other.maxInflightOutboundBatches;
        this.maxInflightReceiveBatches = other.maxInflightReceiveBatches;
        this.visibilityTimeoutSeconds = other.visibilityTimeoutSeconds;
    }

    public String toString() {
        return "QueueBufferConfig [maxBatchSize=" + this.maxBatchSize + ", maxBatchOpenMs=" + this.maxBatchOpenMs + ", longPoll=" + this.longPoll + ", maxInflightOutboundBatches=" + this.maxInflightOutboundBatches + ", maxInflightReceiveBatches=" + this.maxInflightReceiveBatches + ", maxDoneReceiveBatches=" + this.maxDoneReceiveBatches + ", maxBatchSizeBytes=" + this.maxBatchSizeBytes + ", visibilityTimeoutSeconds=" + this.visibilityTimeoutSeconds + ", longPollWaitTimeoutSeconds=" + this.longPollWaitTimeoutSeconds + "]";
    }

    public long getMaxBatchOpenMs() {
        return this.maxBatchOpenMs;
    }

    public void setMaxBatchOpenMs(long maxBatchOpenMs) {
        this.maxBatchOpenMs = maxBatchOpenMs;
    }

    public QueueBufferConfig withMaxBatchOpenMs(long maxBatchOpenMs) {
        this.maxBatchOpenMs = maxBatchOpenMs;
        return this;
    }

    public boolean isLongPoll() {
        return this.longPoll;
    }

    public void setLongPoll(boolean longPoll) {
        this.longPoll = longPoll;
    }

    public QueueBufferConfig withLongPoll(boolean longPoll) {
        this.longPoll = longPoll;
        return this;
    }

    public int getMaxInflightOutboundBatches() {
        return this.maxInflightOutboundBatches;
    }

    public void setMaxInflightOutboundBatches(int maxInflightOutboundBatches) {
        this.maxInflightOutboundBatches = maxInflightOutboundBatches;
    }

    public QueueBufferConfig withMaxInflightOutboundBatches(int maxInflightOutboundBatches) {
        this.maxInflightOutboundBatches = maxInflightOutboundBatches;
        return this;
    }

    public int getMaxInflightReceiveBatches() {
        return this.maxInflightReceiveBatches;
    }

    public void setMaxInflightReceiveBatches(int maxInflightReceiveBatches) {
        this.maxInflightReceiveBatches = maxInflightReceiveBatches;
    }

    public QueueBufferConfig withMaxInflightReceiveBatches(int maxInflightReceiveBatches) {
        this.maxInflightReceiveBatches = maxInflightReceiveBatches;
        return this;
    }

    public int getMaxDoneReceiveBatches() {
        return this.maxDoneReceiveBatches;
    }

    public void setMaxDoneReceiveBatches(int maxDoneReceiveBatches) {
        this.maxDoneReceiveBatches = maxDoneReceiveBatches;
    }

    public QueueBufferConfig withMaxDoneReceiveBatches(int maxDoneReceiveBatches) {
        this.maxDoneReceiveBatches = maxDoneReceiveBatches;
        return this;
    }

    public long getMaxBatchSizeBytes() {
        return this.maxBatchSizeBytes;
    }

    public void setMaxBatchSizeBytes(long maxBatchSizeBytes) {
        if (maxBatchSizeBytes > 262143L) {
            throw new IllegalArgumentException("Maximum Size of the message cannot be greater than the allowed limit of 262143 bytes");
        }
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    public QueueBufferConfig withMaxBatchSizeBytes(long maxBatchSizeBytes) {
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        return this;
    }

    public int getVisibilityTimeoutSeconds() {
        return this.visibilityTimeoutSeconds;
    }

    public void setVisibilityTimeoutSeconds(int visibilityTimeoutSeconds) {
        this.visibilityTimeoutSeconds = visibilityTimeoutSeconds;
    }

    public QueueBufferConfig withVisibilityTimeoutSeconds(int visibilityTimeoutSeconds) {
        this.visibilityTimeoutSeconds = visibilityTimeoutSeconds;
        return this;
    }

    public void setLongPollWaitTimeoutSeconds(int longPollWaitTimeoutSeconds) {
        this.longPollWaitTimeoutSeconds = longPollWaitTimeoutSeconds;
    }

    public int getLongPollWaitTimeoutSeconds() {
        return this.longPollWaitTimeoutSeconds;
    }

    public QueueBufferConfig withLongPollWaitTimeoutSeconds(int longPollWaitTimeoutSeconds) {
        this.longPollWaitTimeoutSeconds = longPollWaitTimeoutSeconds;
        return this;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public QueueBufferConfig withMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    void validate() {
        if (this.visibilityTimeoutSeconds == 0) {
            throw new AmazonClientException("Visibility timeout value may not be equal to zero ");
        }
    }
}

