/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sqs.buffered;

import com.amazonaws.1.10.1.shade.AmazonWebServiceRequest;
import com.amazonaws.1.10.1.shade.services.sqs.buffered.QueueBuffer;
import com.amazonaws.1.10.1.shade.services.sqs.buffered.QueueBufferCallback;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class QueueBufferFuture<Req extends AmazonWebServiceRequest, Res>
implements Future<Res> {
    private Res result = null;
    private Exception e = null;
    private boolean done = false;
    private final QueueBufferCallback<Req, Res> callback;
    private QueueBuffer issuingBuffer = null;

    public QueueBufferFuture() {
        this(null);
    }

    public QueueBufferFuture(QueueBufferCallback<Req, Res> cb) {
        this.callback = cb;
    }

    public synchronized void setSuccess(Res paramResult) {
        if (this.done) {
            return;
        }
        this.result = paramResult;
        this.done = true;
        this.notifyAll();
        if (this.callback != null && this.issuingBuffer != null) {
            QueueBuffer.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    QueueBufferFuture.this.callback.onSuccess(QueueBufferFuture.this.result);
                    return null;
                }
            });
        }
    }

    public synchronized void setFailure(Exception paramE) {
        if (this.done) {
            return;
        }
        this.e = paramE;
        this.done = true;
        this.notifyAll();
        if (this.callback != null && this.issuingBuffer != null) {
            QueueBuffer.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    QueueBufferFuture.this.callback.onError(QueueBufferFuture.this.e);
                    return null;
                }
            });
        }
    }

    @Override
    public boolean cancel(boolean arg0) {
        return false;
    }

    public void setBuffer(QueueBuffer paramBuffer) {
        this.issuingBuffer = paramBuffer;
    }

    @Override
    public Res get() throws InterruptedException, ExecutionException {
        while (true) {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized Res get(long timeout, TimeUnit tu) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMs;
        long waitStartMs = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        long timeToWaitMs = timeoutMs = TimeUnit.MILLISECONDS.convert(timeout, tu);
        while (!this.done) {
            if (timeToWaitMs <= 0L) {
                throw new TimeoutException("Timed out waiting for results after " + timeout + " " + (Object)((Object)tu));
            }
            this.wait(timeToWaitMs);
            long nowMs = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            timeToWaitMs = timeoutMs - (nowMs - waitStartMs);
        }
        if (this.e != null) {
            throw new ExecutionException(this.e);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }
}

