/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sqs.model.transform;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.DefaultRequest;
import com.amazonaws.1.10.1.shade.Request;
import com.amazonaws.1.10.1.shade.services.sqs.model.AddPermissionRequest;
import com.amazonaws.1.10.1.shade.transform.Marshaller;
import com.amazonaws.1.10.1.shade.util.StringUtils;
import java.util.List;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    @Override
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        if (addPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "AmazonSQS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2012-11-05");
        if (addPermissionRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(addPermissionRequest.getQueueUrl()));
        }
        if (addPermissionRequest.getLabel() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.getLabel()));
        }
        List<String> aWSAccountIdsList = addPermissionRequest.getAWSAccountIds();
        int aWSAccountIdsListIndex = 1;
        for (String aWSAccountIdsListValue : aWSAccountIdsList) {
            if (aWSAccountIdsListValue != null) {
                request.addParameter("AWSAccountId." + aWSAccountIdsListIndex, StringUtils.fromString(aWSAccountIdsListValue));
            }
            ++aWSAccountIdsListIndex;
        }
        List<String> actionsList = addPermissionRequest.getActions();
        int actionsListIndex = 1;
        for (String actionsListValue : actionsList) {
            if (actionsListValue != null) {
                request.addParameter("ActionName." + actionsListIndex, StringUtils.fromString(actionsListValue));
            }
            ++actionsListIndex;
        }
        return request;
    }
}

