/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.services.sqs.model.transform;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.DefaultRequest;
import com.amazonaws.1.10.1.shade.Request;
import com.amazonaws.1.10.1.shade.services.sqs.model.MessageAttributeValue;
import com.amazonaws.1.10.1.shade.services.sqs.model.SendMessageRequest;
import com.amazonaws.1.10.1.shade.transform.Marshaller;
import com.amazonaws.1.10.1.shade.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    @Override
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        if (sendMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendMessageRequest> request = new DefaultRequest<SendMessageRequest>(sendMessageRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        if (sendMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(sendMessageRequest.getQueueUrl()));
        }
        if (sendMessageRequest.getMessageBody() != null) {
            request.addParameter("MessageBody", StringUtils.fromString(sendMessageRequest.getMessageBody()));
        }
        if (sendMessageRequest.getDelaySeconds() != null) {
            request.addParameter("DelaySeconds", StringUtils.fromInteger(sendMessageRequest.getDelaySeconds()));
        }
        if (sendMessageRequest != null && sendMessageRequest.getMessageAttributes() != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> messageAttributesListValue : sendMessageRequest.getMessageAttributes().entrySet()) {
                MessageAttributeValue messageAttributeValueValue;
                if (messageAttributesListValue.getKey() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString(messageAttributesListValue.getKey()));
                }
                if ((messageAttributeValueValue = messageAttributesListValue.getValue()) != null) {
                    if (messageAttributeValueValue.getStringValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString(messageAttributeValueValue.getStringValue()));
                    }
                    if (messageAttributeValueValue.getBinaryValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer(messageAttributeValueValue.getBinaryValue()));
                    }
                    List<String> stringListValuesList = messageAttributeValueValue.getStringListValues();
                    int stringListValuesListIndex = 1;
                    for (String stringListValuesListValue : stringListValuesList) {
                        if (stringListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString(stringListValuesListValue));
                        }
                        ++stringListValuesListIndex;
                    }
                    List<ByteBuffer> binaryListValuesList = messageAttributeValueValue.getBinaryListValues();
                    int binaryListValuesListIndex = 1;
                    for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                        if (binaryListValuesListValue != null) {
                            request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer(binaryListValuesListValue));
                        }
                        ++binaryListValuesListIndex;
                    }
                    if (messageAttributeValueValue.getDataType() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString(messageAttributeValueValue.getDataType()));
                    }
                }
                ++messageAttributesListIndex;
            }
        }
        return request;
    }
}

