/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.10.1.shade.util.json;

import com.amazonaws.1.10.1.shade.AmazonClientException;
import com.amazonaws.1.10.1.shade.util.json.JSONArray;
import com.amazonaws.1.10.1.shade.util.json.JSONException;
import com.amazonaws.1.10.1.shade.util.json.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;

public class JSONUtils {
    public static <T> T toObject(Class<T> clazz, String source) throws JSONException {
        JSONObject jsonObect = new JSONObject(source);
        try {
            return JSONUtils.toObject(clazz, jsonObect);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    private static <T> T toObject(Class<T> clazz, JSONObject jsonObject) throws JSONException, IllegalArgumentException, IllegalAccessException {
        T newObject;
        try {
            newObject = JSONUtils.createInstance(clazz);
        }
        catch (Exception e) {
            throw new AmazonClientException("Failed to instantiate class", e);
        }
        for (Field objectField : clazz.getFields()) {
            Object fieldValue;
            String fieldName = objectField.getName();
            Class<?> fieldType = objectField.getType();
            try {
                fieldValue = JSONUtils.parseField(jsonObject, fieldType, fieldName);
            }
            catch (Exception e) {
                fieldValue = JSONUtils.parseField(jsonObject, fieldType, fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1));
            }
            objectField.set(newObject, fieldValue);
        }
        return newObject;
    }

    private static Object parseField(JSONObject jsonObject, Class<?> clazz, String key) throws JSONException, IllegalArgumentException, IllegalAccessException {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return jsonObject.getBoolean(key);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return jsonObject.getDouble(key);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return jsonObject.getInt(key);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return jsonObject.getLong(key);
        }
        if (clazz.equals(String.class)) {
            return jsonObject.getString(key);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf(jsonObject.getString(key).charAt(0));
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            JSONArray jsonArray = jsonObject.getJSONArray(key);
            Object array = Array.newInstance(componentType, jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                Array.set(array, i, JSONUtils.parseField(jsonArray, componentType, i));
            }
            return array;
        }
        JSONObject nestedObject = jsonObject.getJSONObject(key);
        return JSONUtils.toObject(clazz, nestedObject);
    }

    private static Object parseField(JSONArray jsonArray, Class<?> clazz, int index) throws JSONException, IllegalArgumentException, IllegalAccessException {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return jsonArray.getBoolean(index);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return jsonArray.getDouble(index);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return jsonArray.getInt(index);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return jsonArray.getLong(index);
        }
        if (clazz.equals(String.class)) {
            return jsonArray.getString(index);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf(jsonArray.getString(index).charAt(0));
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            JSONArray nestedJSONArray = jsonArray.getJSONArray(index);
            LinkedList<Object> list = new LinkedList<Object>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(JSONUtils.parseField(nestedJSONArray, componentType, i));
            }
            return list.toArray();
        }
        JSONObject nestedObject = jsonArray.getJSONObject(index);
        return JSONUtils.toObject(clazz, nestedObject);
    }

    private static <T> T createInstance(Class<T> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        T instanceToReturn = null;
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null) {
            Object instanceOfEnclosingClass = JSONUtils.createInstance(enclosingClass);
            Constructor<T> ctor = clazz.getConstructor(enclosingClass);
            if (ctor != null) {
                instanceToReturn = ctor.newInstance(instanceOfEnclosingClass);
            }
        } else {
            instanceToReturn = clazz.newInstance();
        }
        return instanceToReturn;
    }
}

