/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.impl.conn;

import java.net.InetAddress;
import org.apache.http.4.3.5.shade.HttpException;
import org.apache.http.4.3.5.shade.HttpHost;
import org.apache.http.4.3.5.shade.HttpRequest;
import org.apache.http.4.3.5.shade.ProtocolException;
import org.apache.http.4.3.5.shade.annotation.Immutable;
import org.apache.http.4.3.5.shade.client.config.RequestConfig;
import org.apache.http.4.3.5.shade.client.protocol.HttpClientContext;
import org.apache.http.4.3.5.shade.conn.SchemePortResolver;
import org.apache.http.4.3.5.shade.conn.UnsupportedSchemeException;
import org.apache.http.4.3.5.shade.conn.routing.HttpRoute;
import org.apache.http.4.3.5.shade.conn.routing.HttpRoutePlanner;
import org.apache.http.4.3.5.shade.impl.conn.DefaultSchemePortResolver;
import org.apache.http.4.3.5.shade.protocol.HttpContext;
import org.apache.http.4.3.5.shade.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

