/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.impl.cookie;

import org.apache.http.4.3.5.shade.annotation.Immutable;
import org.apache.http.4.3.5.shade.cookie.Cookie;
import org.apache.http.4.3.5.shade.cookie.CookieAttributeHandler;
import org.apache.http.4.3.5.shade.cookie.CookieOrigin;
import org.apache.http.4.3.5.shade.cookie.CookieRestrictionViolationException;
import org.apache.http.4.3.5.shade.cookie.MalformedCookieException;
import org.apache.http.4.3.5.shade.cookie.SetCookie;
import org.apache.http.4.3.5.shade.util.Args;
import org.apache.http.4.3.5.shade.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setPath(!TextUtils.isBlank(value) ? value : "/");
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (!this.match(cookie, origin)) {
            throw new CookieRestrictionViolationException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + origin.getPath() + "\"");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        boolean match;
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String targetpath = origin.getPath();
        String topmostPath = cookie.getPath();
        if (topmostPath == null) {
            topmostPath = "/";
        }
        if (topmostPath.length() > 1 && topmostPath.endsWith("/")) {
            topmostPath = topmostPath.substring(0, topmostPath.length() - 1);
        }
        if ((match = targetpath.startsWith(topmostPath)) && targetpath.length() != topmostPath.length() && !topmostPath.endsWith("/")) {
            match = targetpath.charAt(topmostPath.length()) == '/';
        }
        return match;
    }
}

