/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns;

import com.amazonaws.1.10.1.shade.services.sns.AmazonSNS;
import com.amazonaws.1.10.1.shade.services.sns.model.AddPermissionRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.CreateTopicRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.DeleteTopicRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.1.10.1.shade.services.sns.model.ListTopicsRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.PublishRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.RemovePermissionRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.SubscribeRequest;
import com.amazonaws.1.10.1.shade.services.sns.model.UnsubscribeRequest;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.modules.sns.Config;
import org.mule.modules.sns.model.AddPermission;
import org.mule.modules.sns.model.ConfirmSubscription;
import org.mule.modules.sns.model.ListSubscriptions;
import org.mule.modules.sns.model.ListSubscriptionsByTopic;
import org.mule.modules.sns.model.ListTopics;
import org.mule.modules.sns.model.Publish;
import org.mule.modules.sns.model.RemovePermission;
import org.mule.modules.sns.model.Subscribe;
import org.mule.modules.sns.model.SubscriptionAttributes;
import org.mule.modules.sns.model.SubscriptionsByTopic;
import org.mule.modules.sns.model.TopicAttributes;
import org.mule.modules.sns.util.SNSModelFactory;

public class AmazonSNSConnector {
    @NotNull
    private Config config;
    @NotNull
    private AmazonSNS client;

    public void addPermission(AddPermission addPermission) {
        AddPermissionRequest addPermissionRequest = new AddPermissionRequest(addPermission.getTopicArn(), addPermission.getLabel(), addPermission.getaWSAccountIds(), addPermission.getActionNames());
        this.getClient().addPermission(addPermissionRequest);
    }

    public String confirmSubscription(ConfirmSubscription confirmSubscription) {
        ConfirmSubscriptionRequest confirmSubscriptionRequest = new ConfirmSubscriptionRequest(confirmSubscription.getTopicArn(), confirmSubscription.getToken(), confirmSubscription.getAuthenticateOnUnsubscribe());
        return this.getClient().confirmSubscription(confirmSubscriptionRequest).getSubscriptionArn();
    }

    public String createTopic(@NotNull String topicName) {
        CreateTopicRequest createTopicRequest = new CreateTopicRequest(topicName);
        return this.getClient().createTopic(createTopicRequest).getTopicArn();
    }

    public void deleteTopic(@NotNull String topicArn) {
        DeleteTopicRequest deleteTopicRequest = new DeleteTopicRequest(topicArn);
        this.getClient().deleteTopic(deleteTopicRequest);
    }

    public Map<String, String> getSubscriptionAttributes(@NotNull String subscriptionArn) {
        GetSubscriptionAttributesRequest getSubscriptionAttributesRequest = new GetSubscriptionAttributesRequest(subscriptionArn);
        return this.getClient().getSubscriptionAttributes(getSubscriptionAttributesRequest).getAttributes();
    }

    public Map<String, String> getTopicAttributes(@NotNull String topicArn) {
        GetTopicAttributesRequest getTopicAttributesRequest = new GetTopicAttributesRequest(topicArn);
        return this.getClient().getTopicAttributes(getTopicAttributesRequest).getAttributes();
    }

    public ListSubscriptions listSubscriptions(@Nullable String nextToken) {
        ListSubscriptionsRequest listSubscriptionsRequest = new ListSubscriptionsRequest(nextToken);
        ListSubscriptionsResult listSubscriptionsResult = this.getClient().listSubscriptions(listSubscriptionsRequest);
        return SNSModelFactory.getListSubscriptions(listSubscriptionsResult);
    }

    public ListSubscriptionsByTopic listSubscriptionsByTopic(SubscriptionsByTopic subscriptionsByTopic) {
        ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest = new ListSubscriptionsByTopicRequest(subscriptionsByTopic.getTopicArn(), subscriptionsByTopic.getNextToken());
        return SNSModelFactory.getListSubscriptionsByTopic(this.getClient().listSubscriptionsByTopic(listSubscriptionsByTopicRequest));
    }

    public ListTopics listTopics(@Nullable String nextTopic) {
        ListTopicsRequest listTopicsRequest = new ListTopicsRequest(nextTopic);
        return SNSModelFactory.getListTopics(this.getClient().listTopics(listTopicsRequest));
    }

    public String publish(Publish publish) {
        PublishRequest publishRequest = new PublishRequest(publish.getTopicArn(), publish.getMessage(), publish.getSubject());
        publishRequest.setMessageStructure(publish.getMessageStructure());
        publishRequest.setTargetArn(publish.getTargetArn());
        publishRequest.setMessageAttributes(SNSModelFactory.getMessageAttributes(publish.getMessageAttributes()));
        return this.getClient().publish(publishRequest).getMessageId();
    }

    public void removePermission(RemovePermission removePermission) {
        RemovePermissionRequest removePermissionRequest = new RemovePermissionRequest(removePermission.getTopicArn(), removePermission.getLabel());
        this.getClient().removePermission(removePermissionRequest);
    }

    public void setSubscriptionAttributes(SubscriptionAttributes subscriptionAttributes) {
        SetSubscriptionAttributesRequest setSubscriptionAttributesRequest = new SetSubscriptionAttributesRequest(subscriptionAttributes.getSubscriptionArn(), subscriptionAttributes.getAttributeName(), subscriptionAttributes.getAttributeValue());
        this.getClient().setSubscriptionAttributes(setSubscriptionAttributesRequest);
    }

    public void setTopicAttributes(TopicAttributes topicAttributes) {
        SetTopicAttributesRequest setTopicAttributesRequest = new SetTopicAttributesRequest(topicAttributes.getTopicArn(), topicAttributes.getAttributeName(), topicAttributes.getAttributeValue());
        this.getClient().setTopicAttributes(setTopicAttributesRequest);
    }

    public String subscribe(Subscribe subscribe) {
        SubscribeRequest subscribeRequest = new SubscribeRequest(subscribe.getTopicArn(), subscribe.getProtocol(), subscribe.getEndpoint());
        return this.getClient().subscribe(subscribeRequest).getSubscriptionArn();
    }

    public void unsubscribe(@NotNull String subscriptionArn) {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest(subscriptionArn);
        this.getClient().unsubscribe(unsubscribeRequest);
    }

    @NotNull
    public AmazonSNS getClient() {
        return this.client;
    }

    public void setClient(@NotNull AmazonSNS client) {
        this.client = client;
    }

    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(@NotNull Config config) {
        this.config = config;
        this.setClient(config.getClient());
    }
}

