/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sns;

import com.amazonaws.1.10.1.shade.auth.BasicAWSCredentials;
import com.amazonaws.1.10.1.shade.regions.Region;
import com.amazonaws.1.10.1.shade.regions.Regions;
import com.amazonaws.1.10.1.shade.services.sns.AmazonSNS;
import com.amazonaws.1.10.1.shade.services.sns.AmazonSNSClient;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.sns.model.RegionEndpoint;

public class Config {
    private AmazonSNS client;
    private RegionEndpoint region;
    private String testTopicArn;

    public void connect(String accessKey, String secretKey) throws ConnectionException {
        if (StringUtils.isBlank((String)accessKey) || StringUtils.isBlank((String)secretKey)) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "001", "Access Key or Secret Key is blank");
        }
        this.client = new AmazonSNSClient(new BasicAWSCredentials(accessKey, secretKey));
        if (this.region != null) {
            this.client.setEndpoint(this.region.value());
        }
    }

    public void testConnect(String accessKey, String secretKey) throws ConnectionException {
        if (StringUtils.isBlank((String)this.testTopicArn)) {
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, "002", "Specify the ARN of the topic to test connectivity.");
        }
        this.connect(accessKey, secretKey);
        if (this.region == null) {
            this.client.setRegion(Region.getRegion(Regions.fromName(this.extractRegion(this.testTopicArn))));
        }
        try {
            this.client.getTopicAttributes(this.testTopicArn);
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "Invalid Topic Arn or Topic belongs to different region than mentioned in Region Endpoint attribute.\n ", (Throwable)e);
        }
    }

    public void disconnect() {
        this.setClient(null);
    }

    public boolean isConnected() {
        return this.getClient() != null;
    }

    public String connectionId() {
        return "amazon-sns-";
    }

    private String extractRegion(String testTopicArn) {
        String[] strings = testTopicArn.split(":");
        if (strings.length > 3) {
            return strings[3];
        }
        return "us-east-1";
    }

    public AmazonSNS getClient() {
        return this.client;
    }

    public void setClient(AmazonSNS client) {
        this.client = client;
    }

    public RegionEndpoint getRegion() {
        return this.region;
    }

    public void setRegion(RegionEndpoint region) {
        this.region = region;
    }

    public String getTestTopicArn() {
        return this.testTopicArn;
    }

    public void setTestTopicArn(String testTopicArn) {
        this.testTopicArn = testTopicArn;
    }
}

