
package org.mule.modules.sns.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/sns</code>.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.7.1", date = "2015-11-03T01:13:49-03:00", comments = "Build UNNAMED.2613.77421cc")
public class SnsNamespaceHandler
    extends NamespaceHandlerSupport
{

    private static Logger logger = LoggerFactory.getLogger(SnsNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        } catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [sns] is not supported in mule ")+ muleVersion));
        throw new FatalBeanException(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [sns] is not supported in mule ")+ muleVersion), noClassDefFoundError);
    }

    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        try {
            this.registerBeanDefinitionParser("config", new AmazonSNSConnectorConfigConfigDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("add-permission", new AddPermissionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("add-permission", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("confirm-subscription", new ConfirmSubscriptionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("confirm-subscription", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-topic", new CreateTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("create-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-topic", new DeleteTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("delete-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-subscription-attributes", new GetSubscriptionAttributesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-subscription-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-topic-attributes", new GetTopicAttributesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("get-topic-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-subscriptions", new ListSubscriptionsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-subscriptions", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-subscriptions-by-topic", new ListSubscriptionsByTopicDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-subscriptions-by-topic", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("list-topics", new ListTopicsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("list-topics", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("publish", new PublishDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("publish", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("remove-permission", new RemovePermissionDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("remove-permission", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("set-subscription-attributes", new SetSubscriptionAttributesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("set-subscription-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("set-topic-attributes", new SetTopicAttributesDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("set-topic-attributes", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("subscribe", new SubscribeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("subscribe", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("unsubscribe", new UnsubscribeDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("unsubscribe", "@Processor", ex);
        }
    }

}
