/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.Serializable;

/**
 * A wrapper type for the attributes of ConfirmSubscription operation.
 */
public class ConfirmSubscription implements Serializable {

    private static final long serialVersionUID = 3855423002734777051L;

    /**
     * The ARN of the topic for which you wish to confirm a subscription.
     */
    @NotNull
    private String topicArn;

    /**
     * Short-lived token sent to an endpoint during the Subscribe action.
     */
    @NotNull
    private String token;

    /**
     * Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is true and the request has an AWS signature, then only the topic owner and the
     * subscription owner can unsubscribe the endpoint. The unsubscribe action requires AWS authentication.
     */
    @Nullable
    private String authenticateOnUnsubscribe;

    public String getAuthenticateOnUnsubscribe() {
        return authenticateOnUnsubscribe;
    }

    public void setAuthenticateOnUnsubscribe(String authenticateOnUnsubscribe) {
        this.authenticateOnUnsubscribe = authenticateOnUnsubscribe;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}
