/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Response for ListTopics action.
 */
public class ListTopics implements Serializable {

    private static final long serialVersionUID = 4148648207105423995L;

    /**
     * A list of topic ARNs.
     */
    private List<Topic> topics;

    /**
     * Token to pass along to the next ListTopics request.
     */
    private String nextToken;

    public String getNextToken() {
        return nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public List<Topic> getTopics() {
        if (this.topics == null) {
            this.topics = new ArrayList<Topic>();
        }
        return topics;
    }

    public void setTopics(List<Topic> topics) {
        this.topics = topics;
    }
}
