/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * A wrapper type for the attributes of an Publish operation.
 */
public class Publish implements Serializable {

    private static final long serialVersionUID = 6107979801630224605L;
    /**
     * The topic you want to publish to.
     */
    @Nullable
    private String topicArn;

    /**
     * Either TopicArn or EndpointArn, but not both.
     */
    @Nullable
    private String targetArn;

    /**
     * The message you want to send to the topic.
     */
    @NotNull
    private String message;

    /**
     * Optional parameter to be used as the "Subject" line when the message is delivered to email endpoints.
     */
    @Nullable
    private String subject;

    /**
     * Set MessageStructure to json if you want to send a different message for each protocol.
     */
    @Nullable
    private String messageStructure;

    /**
     * Message attributes for Publish action.
     */
    @Nullable
    private Map<String, MessageAttribute> messageAttributes;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, MessageAttribute> getMessageAttributes() {
        if(this.messageAttributes == null) {
            this.messageAttributes = new HashMap<String, MessageAttribute>();
        }
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttribute> messageAttributes) {
        this.messageAttributes = messageAttributes;
    }

    public String getMessageStructure() {
        return messageStructure;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTargetArn() {
        return targetArn;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}
